% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.make_metrics}
\alias{h2o.make_metrics}
\title{Create Model Metrics from predicted and actual values in H2O}
\usage{
h2o.make_metrics(predicted, actuals, domain = NULL, distribution = NULL)
}
\arguments{
\item{predicted}{An H2OFrame containing predictions}

\item{actuals}{An H2OFrame containing actual values}

\item{domain}{Vector with response factors for classification.}

\item{distribution}{Distribution for regression.}
}
\value{
Returns an object of the \linkS4class{H2OModelMetrics} subclass.
}
\description{
Given predicted values (target for regression, class-1 probabilities or binomial
or per-class probabilities for multinomial), compute a model metrics object
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$CAPSULE <- as.factor(prostate$CAPSULE)
prostate_gbm <- h2o.gbm(3:9, "CAPSULE", prostate)
pred <- h2o.predict(prostate_gbm, prostate)[,3] ## class-1 probability
h2o.make_metrics(pred, prostate$CAPSULE)
}
}
