% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.signif}
\alias{h2o.signif}
\alias{signif}
\title{Round doubles/floats to the given number of significant digits.}
\usage{
h2o.signif(x, digits = 6)

signif(x, digits = 6)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{digits}{Number of significant digits to round doubles/floats.}
}
\description{
Round doubles/floats to the given number of significant digits.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "http://s3.amazonaws.com/h2o-public-test-data/smalldata/coxph_test/heart.csv"
heart <- h2o.importFile(f)

h2o.signif(heart["age"], digits = 3)
}
}
\seealso{
\code{\link[base]{Round}} for the base R implementation, \code{signif()}.
}
