% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.melt}
\alias{h2o.melt}
\title{Converts a frame to key-value representation while optionally skipping NA values.
Inverse operation to h2o.pivot.}
\usage{
h2o.melt(
  x,
  id_vars,
  value_vars = NULL,
  var_name = "variable",
  value_name = "value",
  skipna = FALSE
)
}
\arguments{
\item{x}{an H2OFrame}

\item{id_vars}{the columns used as identifiers}

\item{value_vars}{what columns will be converted to key-value pairs (optional, if not specified complement to id_vars will be used)}

\item{var_name}{name of the key-column (default: "variable")}

\item{value_name}{name of the value-column (default: "value")}

\item{skipna}{if enabled, do not include NAs in the result (default: FALSE)}
}
\value{
an unpivoted H2OFrame
}
\description{
Pivot the frame designated by the three columns: index, column, and value. Index and column should be
of type enum, int, or time.
For cases of multiple indexes for a column label, the aggregation method is to pick the first occurrence in the data frame
}
