/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_choiceRT_ddm_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_choiceRT_ddm");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_choiceRT_ddm");
    reader.add_event(112, 97, "end", "model_choiceRT_ddm");
    return reader;
}

#include <meta_header.hpp>
 class model_choiceRT_ddm : public prob_grad {
private:
    int N;
    int Nu_max;
    int Nl_max;
    vector<int> Nu;
    vector<int> Nl;
    vector<vector<double> > RTu;
    vector<vector<double> > RTl;
    vector<double> minRT;
    double RTbound;
public:
    model_choiceRT_ddm(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_choiceRT_ddm(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_choiceRT_ddm_namespace::model_choiceRT_ddm";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "Nu_max", "int", context__.to_vec());
            Nu_max = int(0);
            vals_i__ = context__.vals_i("Nu_max");
            pos__ = 0;
            Nu_max = vals_i__[pos__++];
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "Nl_max", "int", context__.to_vec());
            Nl_max = int(0);
            vals_i__ = context__.vals_i("Nl_max");
            pos__ = 0;
            Nl_max = vals_i__[pos__++];
            current_statement_begin__ = 21;
            validate_non_negative_index("Nu", "N", N);
            context__.validate_dims("data initialization", "Nu", "int", context__.to_vec(N));
            validate_non_negative_index("Nu", "N", N);
            Nu = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Nu");
            pos__ = 0;
            size_t Nu_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Nu_limit_0__; ++i_0__) {
                Nu[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("Nl", "N", N);
            context__.validate_dims("data initialization", "Nl", "int", context__.to_vec(N));
            validate_non_negative_index("Nl", "N", N);
            Nl = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Nl");
            pos__ = 0;
            size_t Nl_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Nl_limit_0__; ++i_0__) {
                Nl[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("RTu", "N", N);
            validate_non_negative_index("RTu", "Nu_max", Nu_max);
            context__.validate_dims("data initialization", "RTu", "double", context__.to_vec(N,Nu_max));
            validate_non_negative_index("RTu", "N", N);
            validate_non_negative_index("RTu", "Nu_max", Nu_max);
            RTu = std::vector<std::vector<double> >(N,std::vector<double>(Nu_max,double(0)));
            vals_r__ = context__.vals_r("RTu");
            pos__ = 0;
            size_t RTu_limit_1__ = Nu_max;
            for (size_t i_1__ = 0; i_1__ < RTu_limit_1__; ++i_1__) {
                size_t RTu_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < RTu_limit_0__; ++i_0__) {
                    RTu[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("RTl", "N", N);
            validate_non_negative_index("RTl", "Nl_max", Nl_max);
            context__.validate_dims("data initialization", "RTl", "double", context__.to_vec(N,Nl_max));
            validate_non_negative_index("RTl", "N", N);
            validate_non_negative_index("RTl", "Nl_max", Nl_max);
            RTl = std::vector<std::vector<double> >(N,std::vector<double>(Nl_max,double(0)));
            vals_r__ = context__.vals_r("RTl");
            pos__ = 0;
            size_t RTl_limit_1__ = Nl_max;
            for (size_t i_1__ = 0; i_1__ < RTl_limit_1__; ++i_1__) {
                size_t RTl_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < RTl_limit_0__; ++i_0__) {
                    RTl[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 25;
            validate_non_negative_index("minRT", "N", N);
            context__.validate_dims("data initialization", "minRT", "double", context__.to_vec(N));
            validate_non_negative_index("minRT", "N", N);
            minRT = std::vector<double>(N,double(0));
            vals_r__ = context__.vals_r("minRT");
            pos__ = 0;
            size_t minRT_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < minRT_limit_0__; ++i_0__) {
                minRT[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "RTbound", "double", context__.to_vec());
            RTbound = double(0);
            vals_r__ = context__.vals_r("RTbound");
            pos__ = 0;
            RTbound = vals_r__[pos__++];

            // validate, data variables
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 19;
            check_greater_or_equal(function__,"Nu_max",Nu_max,0);
            current_statement_begin__ = 20;
            check_greater_or_equal(function__,"Nl_max",Nl_max,0);
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Nu[k0__]",Nu[k0__],0);
            }
            current_statement_begin__ = 22;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Nl[k0__]",Nl[k0__],0);
            }
            current_statement_begin__ = 23;
            current_statement_begin__ = 24;
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 42;
            validate_non_negative_index("mu_pr", "4", 4);
            num_params_r__ += 4;
            current_statement_begin__ = 43;
            validate_non_negative_index("sigma", "4", 4);
            num_params_r__ += 4;
            current_statement_begin__ = 46;
            validate_non_negative_index("alpha_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 47;
            validate_non_negative_index("beta_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 48;
            validate_non_negative_index("delta_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 49;
            validate_non_negative_index("tau_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_choiceRT_ddm() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "4", 4);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(4));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "4", 4);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(4));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(4));
        for (int j1__ = 0U; j1__ < 4; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("alpha_pr")))
            throw std::runtime_error("variable alpha_pr missing");
        vals_r__ = context__.vals_r("alpha_pr");
        pos__ = 0U;
        validate_non_negative_index("alpha_pr", "N", N);
        context__.validate_dims("initialization", "alpha_pr", "vector_d", context__.to_vec(N));
        vector_d alpha_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            alpha_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(alpha_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha_pr: ") + e.what());
        }

        if (!(context__.contains_r("beta_pr")))
            throw std::runtime_error("variable beta_pr missing");
        vals_r__ = context__.vals_r("beta_pr");
        pos__ = 0U;
        validate_non_negative_index("beta_pr", "N", N);
        context__.validate_dims("initialization", "beta_pr", "vector_d", context__.to_vec(N));
        vector_d beta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            beta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(beta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta_pr: ") + e.what());
        }

        if (!(context__.contains_r("delta_pr")))
            throw std::runtime_error("variable delta_pr missing");
        vals_r__ = context__.vals_r("delta_pr");
        pos__ = 0U;
        validate_non_negative_index("delta_pr", "N", N);
        context__.validate_dims("initialization", "delta_pr", "vector_d", context__.to_vec(N));
        vector_d delta_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            delta_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(delta_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta_pr: ") + e.what());
        }

        if (!(context__.contains_r("tau_pr")))
            throw std::runtime_error("variable tau_pr missing");
        vals_r__ = context__.vals_r("tau_pr");
        pos__ = 0U;
        validate_non_negative_index("tau_pr", "N", N);
        context__.validate_dims("initialization", "tau_pr", "vector_d", context__.to_vec(N));
        vector_d tau_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            tau_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(tau_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(4,lp__);
            else
                mu_pr = in__.vector_constrain(4);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,4,lp__);
            else
                sigma = in__.vector_lb_constrain(0,4);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha_pr;
            (void) alpha_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_pr = in__.vector_constrain(N,lp__);
            else
                alpha_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta_pr;
            (void) beta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_pr = in__.vector_constrain(N,lp__);
            else
                beta_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  delta_pr;
            (void) delta_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                delta_pr = in__.vector_constrain(N,lp__);
            else
                delta_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau_pr;
            (void) tau_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                tau_pr = in__.vector_constrain(N,lp__);
            else
                tau_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 54;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha;  // dummy to suppress unused var warning

            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 55;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("delta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  delta(static_cast<Eigen::VectorXd::Index>(N));
            (void) delta;  // dummy to suppress unused var warning

            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta,DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 59;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 60;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))), 
                            "assigning variable beta");
                current_statement_begin__ = 61;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((Phi_approx((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * (get_base1(minRT,i,"minRT",1) - RTbound)) + RTbound), 
                            "assigning variable tau");
            }
            current_statement_begin__ = 63;
            stan::math::assign(alpha, stan::math::exp(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),alpha_pr))));
            current_statement_begin__ = 64;
            stan::math::assign(delta, stan::math::exp(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),delta_pr))));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(alpha(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: alpha" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(beta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(delta(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: delta" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(tau(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tau" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 54;
            check_greater_or_equal(function__,"alpha",alpha,0);
            current_statement_begin__ = 55;
            check_greater_or_equal(function__,"beta",beta,0);
            check_less_or_equal(function__,"beta",beta,1);
            current_statement_begin__ = 56;
            check_greater_or_equal(function__,"delta",delta,0);
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"tau",tau,RTbound);
            check_less_or_equal(function__,"tau",tau,max(minRT));

            // model body

            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1));
            current_statement_begin__ = 70;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 73;
            lp_accum__.add(normal_log<propto__>(alpha_pr, 0, 1));
            current_statement_begin__ = 74;
            lp_accum__.add(normal_log<propto__>(beta_pr, 0, 1));
            current_statement_begin__ = 75;
            lp_accum__.add(normal_log<propto__>(delta_pr, 0, 1));
            current_statement_begin__ = 76;
            lp_accum__.add(normal_log<propto__>(tau_pr, 0, 1));
            current_statement_begin__ = 79;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 81;
                lp_accum__.add(wiener_log<propto__>(stan::model::rvalue(RTu, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_max(get_base1(Nu,i,"Nu",1)), stan::model::nil_index_list())), "RTu"), get_base1(alpha,i,"alpha",1), get_base1(tau,i,"tau",1), get_base1(beta,i,"beta",1), get_base1(delta,i,"delta",1)));
                current_statement_begin__ = 82;
                lp_accum__.add(wiener_log<propto__>(stan::model::rvalue(RTl, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_max(get_base1(Nl,i,"Nl",1)), stan::model::nil_index_list())), "RTl"), get_base1(alpha,i,"alpha",1), get_base1(tau,i,"tau",1), (1 - get_base1(beta,i,"beta",1)), -(get_base1(delta,i,"delta",1))));
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("alpha_pr");
        names__.push_back("beta_pr");
        names__.push_back("delta_pr");
        names__.push_back("tau_pr");
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("delta");
        names__.push_back("tau");
        names__.push_back("mu_alpha");
        names__.push_back("mu_beta");
        names__.push_back("mu_delta");
        names__.push_back("mu_tau");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(4);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_choiceRT_ddm_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(4);
        vector_d sigma = in__.vector_lb_constrain(0,4);
        vector_d alpha_pr = in__.vector_constrain(N);
        vector_d beta_pr = in__.vector_constrain(N);
        vector_d delta_pr = in__.vector_constrain(N);
        vector_d tau_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 4; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(delta_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 54;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  alpha(static_cast<Eigen::VectorXd::Index>(N));
            (void) alpha;  // dummy to suppress unused var warning

            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha,DUMMY_VAR__);
            current_statement_begin__ = 55;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  beta(static_cast<Eigen::VectorXd::Index>(N));
            (void) beta;  // dummy to suppress unused var warning

            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta,DUMMY_VAR__);
            current_statement_begin__ = 56;
            validate_non_negative_index("delta", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  delta(static_cast<Eigen::VectorXd::Index>(N));
            (void) delta;  // dummy to suppress unused var warning

            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta,DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("tau", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  tau(static_cast<Eigen::VectorXd::Index>(N));
            (void) tau;  // dummy to suppress unused var warning

            stan::math::initialize(tau, DUMMY_VAR__);
            stan::math::fill(tau,DUMMY_VAR__);


            current_statement_begin__ = 59;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 60;
                stan::model::assign(beta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,2,"mu_pr",1) + (get_base1(sigma,2,"sigma",1) * get_base1(beta_pr,i,"beta_pr",1)))), 
                            "assigning variable beta");
                current_statement_begin__ = 61;
                stan::model::assign(tau, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((Phi_approx((get_base1(mu_pr,4,"mu_pr",1) + (get_base1(sigma,4,"sigma",1) * get_base1(tau_pr,i,"tau_pr",1)))) * (get_base1(minRT,i,"minRT",1) - RTbound)) + RTbound), 
                            "assigning variable tau");
            }
            current_statement_begin__ = 63;
            stan::math::assign(alpha, stan::math::exp(add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),alpha_pr))));
            current_statement_begin__ = 64;
            stan::math::assign(delta, stan::math::exp(add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),delta_pr))));

            // validate transformed parameters
            current_statement_begin__ = 54;
            check_greater_or_equal(function__,"alpha",alpha,0);
            current_statement_begin__ = 55;
            check_greater_or_equal(function__,"beta",beta,0);
            check_less_or_equal(function__,"beta",beta,1);
            current_statement_begin__ = 56;
            check_greater_or_equal(function__,"delta",delta,0);
            current_statement_begin__ = 57;
            check_greater_or_equal(function__,"tau",tau,RTbound);
            check_less_or_equal(function__,"tau",tau,max(minRT));

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(beta[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(delta[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(tau[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 89;
            local_scalar_t__ mu_alpha;
            (void) mu_alpha;  // dummy to suppress unused var warning

            stan::math::initialize(mu_alpha, DUMMY_VAR__);
            stan::math::fill(mu_alpha,DUMMY_VAR__);
            current_statement_begin__ = 90;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_beta, DUMMY_VAR__);
            stan::math::fill(mu_beta,DUMMY_VAR__);
            current_statement_begin__ = 91;
            local_scalar_t__ mu_delta;
            (void) mu_delta;  // dummy to suppress unused var warning

            stan::math::initialize(mu_delta, DUMMY_VAR__);
            stan::math::fill(mu_delta,DUMMY_VAR__);
            current_statement_begin__ = 92;
            local_scalar_t__ mu_tau;
            (void) mu_tau;  // dummy to suppress unused var warning

            stan::math::initialize(mu_tau, DUMMY_VAR__);
            stan::math::fill(mu_tau,DUMMY_VAR__);
            current_statement_begin__ = 95;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);


            current_statement_begin__ = 98;
            stan::math::assign(mu_alpha, stan::math::exp(get_base1(mu_pr,1,"mu_pr",1)));
            current_statement_begin__ = 99;
            stan::math::assign(mu_beta, Phi_approx(get_base1(mu_pr,2,"mu_pr",1)));
            current_statement_begin__ = 100;
            stan::math::assign(mu_delta, stan::math::exp(get_base1(mu_pr,3,"mu_pr",1)));
            current_statement_begin__ = 101;
            stan::math::assign(mu_tau, ((Phi_approx(get_base1(mu_pr,4,"mu_pr",1)) * (mean(minRT) - RTbound)) + RTbound));

            current_statement_begin__ = 105;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 106;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            wiener_log(stan::model::rvalue(RTu, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_max(get_base1(Nu,i,"Nu",1)), stan::model::nil_index_list())), "RTu"),get_base1(alpha,i,"alpha",1),get_base1(tau,i,"tau",1),get_base1(beta,i,"beta",1),get_base1(delta,i,"delta",1)), 
                            "assigning variable log_lik");
                current_statement_begin__ = 107;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + wiener_log(stan::model::rvalue(RTl, stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_max(get_base1(Nl,i,"Nl",1)), stan::model::nil_index_list())), "RTl"),get_base1(alpha,i,"alpha",1),get_base1(tau,i,"tau",1),(1 - get_base1(beta,i,"beta",1)),-(get_base1(delta,i,"delta",1)))), 
                            "assigning variable log_lik");
            }

            // validate generated quantities
            current_statement_begin__ = 89;
            check_greater_or_equal(function__,"mu_alpha",mu_alpha,0);
            current_statement_begin__ = 90;
            check_greater_or_equal(function__,"mu_beta",mu_beta,0);
            check_less_or_equal(function__,"mu_beta",mu_beta,1);
            current_statement_begin__ = 91;
            check_greater_or_equal(function__,"mu_delta",mu_delta,0);
            current_statement_begin__ = 92;
            check_greater_or_equal(function__,"mu_tau",mu_tau,RTbound);
            check_less_or_equal(function__,"mu_tau",mu_tau,max(minRT));
            current_statement_begin__ = 95;

            // write generated quantities
        vars__.push_back(mu_alpha);
        vars__.push_back(mu_beta);
        vars__.push_back(mu_delta);
        vars__.push_back(mu_tau);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_choiceRT_ddm";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_delta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 4; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "delta" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_delta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}

typedef model_choiceRT_ddm_namespace::model_choiceRT_ddm stan_model;


#endif
