% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_ic.R
\name{extract_ic}
\alias{extract_ic}
\title{Extract Model Comparison Estimates}
\usage{
extract_ic(model_data = NULL, ic = "looic", ncore = 2)
}
\arguments{
\item{model_data}{Object returned by \code{'hBayesDM'} model function}

\item{ic}{Information Criterion. 'looic', 'waic', or 'both'}

\item{ncore}{Number of cores to use when computing LOOIC}
}
\value{
IC Leave-One-Out and/or Watanabe-Akaike information criterion estimates.
}
\description{
Extract Model Comparison Estimates
}
\examples{
\dontrun{
library(hBayesDM)
output = bandit2arm_delta("example", niter = 2000, nwarmup = 1000, nchain = 4, ncore = 1)
# To show the LOOIC model fit estimates (a detailed report; c)
extract_ic(output)
# To show the WAIC model fit estimates
extract_ic(output, ic = "waic")
}

}
