% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateNMFResult.R
\name{validateNMFResult}
\alias{validateNMFResult}
\title{Validation tool for (h)NMF based segmentation.}
\usage{
validateNMFResult(nmfInput, nmfModel, sliceRange, indTumor = 0,
  indNecrosis = 0, indEdema = 0, tumorNiftiFile = NULL,
  necrosisNiftiFile = NULL, edemaNiftiFile = NULL)
}
\arguments{
\item{nmfInput}{List with NMF input attributes}

\item{nmfModel}{NMF model (in accordance with NMF package definition)}

\item{sliceRange}{2-element vector containing first and last image slice number
that were analyzed}

\item{indTumor, indNecrosis, indEdema}{Indices of the NMF sources representing 
tumor, necrosis and edema, respectively}

\item{tumorNiftiFile, necrosisNiftiFile, edemaNiftiFile}{Character strings containing 
the path to the manual segmentation files (in nifti format) for tumor, necrosis and edema}
}
\value{
Dice scores quantifying the segmentation quality are printed in the R console
}
\description{
This function converts NMF abundance maps to actual segmentation results,
and validates the result with respect to manual segmentation. The manual segmentation results 
are provided in nifti (.nii) format. Segmentation overlap is quantified by means of the Dice-score.
Input to the method is the NMF input data and a valid nmfModel object obtained from the NMF package.
sliceRange must be a 2-element vector specifying the analyzed slice range.
}
\author{
Nicolas Sauwen
}
