% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvc_readutils.R
\name{cvc_read_loops}
\alias{cvc_read_loops}
\title{read HDF5 loop files in the CVC loop format}
\usage{
cvc_read_loops(selections, files, Time, nstoch, verbose = FALSE,
  check_group_names = FALSE)
}
\arguments{
\item{selections}{Named list with names from the list 'Naive', 'Scalar', 'dOp', 'Loops'
'LpsDw', 'LpsDwCv', 'LoopsCv' specifying the requesetd loop types.
The elements of this list are in turn expected
be data frames of the form
\tabular{rrr}{
\strong{qx} \tab \strong{qy} \tab \strong{qz} \cr
0           \tab 0           \tab 1           \cr
-2          \tab 1           \tab -3          \cr
...         \tab ...         \tab ...
}
specifying the momentum combinations to be extracted for each
loop type.}

\item{files}{Vector of strings, list of HDF5 files to be processed.}

\item{Time}{Integer, time extent of the lattice.}

\item{nstoch}{Integer, number of stochastic samples to be expected in file.}

\item{verbose}{Boolean, output I/O time per file. Requires 'tictoc' package. Default FALSE.}

\item{check_group_names}{Boolean, check if the group names that we're about to read actually
exist in the file. This is quite slow because it uses \code{rhdf5::h5ls}.
Default FALSE.}
}
\value{
Named nested list of the same length as \code{selections} containg the loop data
in the \link{raw_cf} format. Each named element corresponds to one loop
type and each element of the underlying numbered list corresponds to one momentum
combination as specified via \code{selections} for this loop type in the same order.
}
\description{
The CVC naive_loops code produces HDF5 files which contain
a matrix of momenta and the data for the loops (without
spin projection) organised by stochastic sample. Currently, the
reading code assumes that there is a single configuration stored per
file and the "trajectory" parameter in CalcLoops is assumed
to take its default value of '4'.
}
