% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf_xml_writer.R
\name{rdf_xml_writer}
\alias{rdf_xml_writer}
\title{RDF XML writer}
\usage{
rdf_xml_writer(z, ...)
}
\arguments{
\item{z}{an object of class \code{handl}; see \link{handl} for more}

\item{...}{further params passed to \code{\link[jsonld:jsonld]{jsonld::jsonld_to_rdf()}}}
}
\value{
RDF XML
}
\description{
RDF XML writer
}
\details{
package \code{jsonld} required for this writer
}
\examples{
if (require("jsonld") && interactive()) {
  library("jsonld")
  z <- system.file('extdata/citeproc.json', package = "handlr")
  (tmp <- citeproc_reader(z))
 
  if (requireNamespace("bibtex", quietly=TRUE)) {
  (z <- system.file('extdata/bibtex.bib', package = "handlr"))
  (tmp <- bibtex_reader(z))
  rdf_xml_writer(z = tmp)
  cat(rdf_xml_writer(z = tmp))
  }
}
}
\seealso{
Other writers: 
\code{\link{bibtex_writer}()},
\code{\link{cff_writer}()},
\code{\link{citeproc_writer}()},
\code{\link{codemeta_writer}()},
\code{\link{ris_writer}()},
\code{\link{schema_org_writer}()}
}
\concept{rdf-xml}
\concept{writers}
