% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_assignment.R
\name{get_clusters_batch}
\alias{get_clusters_batch}
\title{get_clusters_batch}
\usage{
get_clusters_batch(
  template,
  input_dir,
  output_dir,
  writer_indices,
  doc_indices,
  num_cores = 1,
  save_master_file = FALSE
)
}
\arguments{
\item{template}{A cluster template created with \code{\link{make_clustering_template}}}

\item{input_dir}{A directory containing graphs created with
\code{\link{process_batch_dir}}}

\item{output_dir}{Output directory for cluster assignments}

\item{writer_indices}{Vector of start and end indices for the writer id in
the graph file names}

\item{doc_indices}{Vector of start and end indices for the document id in the
graph file names}

\item{num_cores}{Integer number of cores to use for parallel processing}

\item{save_master_file}{TRUE or FALSE. If TRUE, a master file named
'all_clusters.rds' containing the cluster assignments for all documents in
the input directory will be saved to the output directory. If FASLE, a
master file will not be saved, but the individual files for each document
in the input directory will still be saved to the output directory.}
}
\value{
A list of cluster assignments
}
\description{
get_clusters_batch
}
\examples{
\dontrun{
template <- readRDS('path/to/template.rds')
get_clusters_batch(template=template, input_dir='path/to/dir', output_dir='path/to/dir',
writer_indices=c(2,5), doc_indices=c(7,18), num_cores=1)

get_clusters_batch(template=template, input_dir='path/to/dir', output_dir='path/to/dir',
writer_indices=c(1,4), doc_indices=c(5,10), num_cores=5)
}

}
