% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wfs.R
\name{get_wfs}
\alias{get_wfs}
\title{Download WFS layer}
\usage{
get_wfs(shape,
        apikey = "cartovecto",
        layer_name = "BDCARTO_BDD_WLD_WGS84G:troncon_route",
        filename = NULL,
        overwrite = FALSE,
        interactive = FALSE)
}
\arguments{
\item{shape}{Object of class \code{sf}. Needs to be located in
France. Bbox of shape is used to intersect features.}

\item{apikey}{API key from \code{get_apikeys()} or directly
from \href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{layer_name}{Name of the layer from \code{get_layers_metadata(apikey, "wfs")}
or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}}

\item{filename}{Either a character string naming a file or a connection open
for writing. (ex : "test.shp" or "~/test.shp")}

\item{overwrite}{If TRUE, file is overwrite}

\item{interactive}{if set to TRUE, no need to specify \code{apikey} and \code{layer_name}, you'll be ask.}
}
\value{
\code{get_wfs}return an object of class \code{sf}
}
\description{
Download a shapefile layer from IGN Web Feature Service (WFS).
To do that, it need a location giving by a shape, an apikey
and the name of layer. You can find those information from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}
}
\details{
\itemize{
\item IGN limits the number of shapes downloaded at the same time to 1000.
get_wfs allows to override this limit by making repeated requests but if very
large input areas is used (ex : all of France), depending on the resource,
this can be time consuming;
\item By default, when \code{filename} is set, shape are saved as .shp but if names are too
long, .gpkg is used.
}
}
\examples{
\dontrun{
library(sf)
library(tmap)

# One point from the best town in France
shape <- st_point(c(-4.373937, 47.79859))
shape <- st_sfc(shape, crs = st_crs(4326))

# For quick testing, use interactive = TRUE
shape_of_my_choice <- get_wfs(shape = shape,
                              interactive = TRUE)

# For specific use, choose apikey with get_apikey() and layer_name with get_layers_metadata()
## Getting borders of best town in France
apikey <- get_apikeys()[1]
metadata_table <- get_layers_metadata(apikey, "wfs")
layer_name <- as.character(metadata_table[32,1])

# Downloading borders
borders <- get_wfs(shape, apikey, layer_name)

# Plotting result
qtm(borders, fill = NULL, borders = "firebrick") # easy map

## Get forest_area of the best town in France
forest_area <- get_wfs(shape = borders,
                       apikey = "environnement",
                       layer_name = "LANDCOVER.FORESTINVENTORY.V1:resu_bdv1_shape")

qtm(forest_area, fill = "libelle")

}
}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}, \code{\link[=get_layers_metadata]{get_layers_metadata()}}
}
