% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wmts.R
\name{get_wmts}
\alias{get_wmts}
\title{Download WMTS raster tiles}
\usage{
get_wmts(x,
         layer = "ORTHOIMAGERY.ORTHOPHOTOS",
         zoom = 10L,
         crs = 2154,
         filename = tempfile(fileext = ".tif"),
         overwrite = FALSE,
         interactive = FALSE)
}
\arguments{
\item{x}{Object of class \code{sf} or \code{sfc}. Needs to be located in
France.}

\item{layer}{\code{character}; layer name from
\code{get_layers_metadata(apikey, "wms")} or directly from
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}.}

\item{zoom}{\code{integer} between 0 and 21; at low zoom levels, a small set of
map tiles covers a large geographical area. In other words, the smaller
the zoom level, the less precise the resolution. For conversion between zoom
level and resolution see
\href{https://geoservices.ign.fr/documentation/services/services-geoplateforme/diffusion#70062}{WMTS IGN Documentation}}

\item{crs}{\code{numeric}, \code{character}, or object of class \code{sf} or \code{sfc}.
It is set to EPSG:2154 by default. See \code{\link[sf:st_crs]{sf::st_crs()}} for more detail.}

\item{filename}{\code{character} or \code{NULL}; filename or a open connection for
writing. (ex : "test.tif" or "~/test.tif"). If \code{NULL}, \code{layer} is used as
filename. Default drivers is ".tif" but all gdal drivers are supported,
see details for more info.}

\item{overwrite}{If TRUE, output raster is overwrite.}

\item{interactive}{\code{logical}; If TRUE, interactive menu ask for
\code{apikey} and \code{layer}.}
}
\value{
\code{SpatRaster} object from \code{terra} package.
}
\description{
Download an RGB raster layer from IGN Web Map Tile Services (WMTS).
WMTS focuses on performance and can only query pre-calculated
tiles.
}
\examples{
\dontrun{
library(sf)
library(tmap)

penmarch <- read_sf(system.file("extdata/penmarch.shp", package = "happign"))

# Get orthophoto
layers <- get_layers_metadata("wmts", "ortho")$Identifier
ortho <- get_wmts(penmarch, layer = layers[1], zoom = 21)
plotRGB(ortho)

# Get all available irc images
layers <- get_layers_metadata("wmts", "orthohisto")$Identifier
irc_names <- grep("irc", layers, value = TRUE, ignore.case = TRUE)

irc <- lapply(irc_names, function(x) get_wmts(penmarch, layer = x, zoom = 18)) |>
   setNames(irc_names)

# remove empty layer (e.g. only NA)
irc <- Filter(function(x) !all(is.na(values(x))), irc)

# plot
all_plots <- lapply(irc, plotRGB)

}
}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}, \code{\link[=get_layers_metadata]{get_layers_metadata()}}
}
