% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hce.R
\name{hce}
\alias{hce}
\title{Helper function for \code{hce} objects}
\usage{
hce(
  GROUP = character(),
  TRTP = character(),
  AVAL0 = 0,
  ORD = sort(unique(GROUP))
)
}
\arguments{
\item{GROUP}{a character vector of the same length as \code{AVAL} containing events.}

\item{TRTP}{a character vector of the same length as \code{AVAL} containing assigned treatment groups.}

\item{AVAL0}{a numeric vector of analysis values within each category. The default is 0.}

\item{ORD}{a character vector containing ordered unique values of the \code{GROUP} variable for determining the hierarchy of events.}
}
\value{
an object of class \code{hce}. Its is a subject-level data frame (each row corresponds to one subject), containing the following columns:
\itemize{
\item SUBJID subject ID.
\item GROUP a character vector specifying the type of the outcome the patient experienced - either a TTE (time-to-event) or C (continuous).
\item GROUPN a numeric vector version of the \code{GROUP} column.
\item AVAL0 original analysis values - time of the time-to-event outcomes or the continuous outcome.
\item AVAL derived analysis value \code{AVAL = AVAL0 + GROUPN}.
\item TRTP assigned treatment groups.
}
}
\description{
Helper function for \code{hce} objects
}
\examples{
# Example 1
set.seed(2022)
d <- hce(GROUP = sample(x = c("A", "B", "C"), size = 10, replace = TRUE), 
TRTP = rep(c("Active", "Control"), each = 5), 
AVAL0 = c(rnorm(5, mean = 1), rnorm(5)), ORD = c("A", "B", "C"))
calcWO(d, ref = "Control")
}
\seealso{
\code{\link[=as_hce]{as_hce()}} for coercing to \code{hce} objects.
}
