% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_rmap_bhm.R
\name{glm.rmap.bhm}
\alias{glm.rmap.bhm}
\title{Posterior of robust meta-analytic predictive prior (RMAP)}
\usage{
glm.rmap.bhm(
  formula,
  family,
  hist.data.list,
  hist.offset.list = NULL,
  meta.mean.mean = NULL,
  meta.mean.sd = NULL,
  meta.sd.mean = NULL,
  meta.sd.sd = NULL,
  hist.disp.mean = NULL,
  hist.disp.sd = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}.}

\item{hist.data.list}{a list of \code{data.frame}s. Each element in the list is a historical data set.}

\item{hist.offset.list}{a list of vectors giving the offsets for each historical data. The length of hist.offset.list is
equal to the length of hist.data.list. The length of each element of hist.offset.list is equal
to the number of rows in the corresponding element of hist.data.list. Defaults to a list of
vectors of 0s.}

\item{meta.mean.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the means for the normal hyperpriors on the mean hyperparameters of regression coefficients. If
a scalar is provided, meta.mean.mean will be a vector of repeated elements of the given scalar.
Defaults to a vector of 0s.}

\item{meta.mean.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sds for the normal hyperpriors on the mean hyperparameters of regression coefficients. If a
scalar is provided, same as for meta.mean.mean. Defaults to a vector of 1s.}

\item{meta.sd.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the means for the half-normal hyperpriors on the sd hyperparameters of regression coefficients.
If a scalar is provided, same as for meta.mean.mean. Defaults to a vector of 0s.}

\item{meta.sd.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sds for the half-normal hyperpriors on the sd hyperparameters of regression coefficients.
If a scalar is provided, same as for meta.mean.mean. Defaults to a vector of 10s.}

\item{hist.disp.mean}{a scalar or a vector whose dimension is equal to the number of historical data sets giving the
means for the half-normal hyperpriors on the dispersion parameters. If a scalar is provided,
same as for meta.mean.mean. Defaults to a vector of 0s.}

\item{hist.disp.sd}{a scalar or a vector whose dimension is equal to the number of historical data sets giving the
sds for the half-normal hyperpriors on the dispersion parameters. If a scalar is provided, same
as for meta.mean.mean. Defaults to a vector of 10s.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g. seed, refresh, init).}
}
\value{
The function returns a matrix of the samples of regression coefficients from the prior induced by the BHM.
The number of columns is equal to the number of regression coefficients, and the number of rows is equal to
the number of MCMC samples.
}
\description{
First step for sampling from the posterior distribution of a GLM using the RMAP by Schmidli et al. (2014) \url{doi:10.1111/biom.12242}.
}
\details{
The RMAP is a mixture prior of two components where one component is a prior induced by the Bayesian hierarchical model (BHM),
and the other is a vague (noninformative) prior. This function samples from the prior induced by the BHM.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg036) ## historical data
  ## take subset for speed purposes
  actg036 = actg036[1:50, ]
  hist_data_list = list(actg036)
  glm.rmap.bhm(
    formula = outcome ~ scale(age) + race + treatment + scale(cd4),
    family = binomial('logit'),
    hist.data.list = hist_data_list,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
}
}
\seealso{
\code{\link[=glm.rmap.bhm.approx]{glm.rmap.bhm.approx()}} for the second step and \code{\link[=glm.rmap]{glm.rmap()}} for the final step of implementing RMAP.
}
