% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T_ARRAY-class}
\alias{H5T_ARRAY-class}
\alias{H5T_ARRAY}
\title{Class for HDF5 array datatypes.}
\value{
Object of class \code{\link[=H5T_ARRAY]{H5T_ARRAY}}.
}
\description{
Inherits from class \code{\link[=H5T]{H5T}}. This class represents an array. As datasets in HDF5
are itself already arrays, this datatype is not needed there. It is mostly useful when a column in a
\code{H5T_COMPUND} object is intended to be an array. This however makes it difficult to work
with such objects in R - as a column of the corresponding \code{data.frame} has to be an array. So please
use with care.
}
\section{Methods}{

\describe{
\item{\code{new(dims, dtype_base, id = NULL)}}{

Create an array datatype.

\strong{Parameters}
\describe{
\item{dims}{The dimension of the datatype}
\item{dtype_base}{The datatype that makes up the elements of the array}
\item{id}{internal use only}
}}

\item{\code{get_array_ndims()}}{

This function implements the HDF5-API function H5Tget_array_ndims.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_array_dims()}}{

This function implements the HDF5-API function H5Tget_array_dims2.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_super()}}{

This function implements the HDF5-API function H5Tget_super.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{describe()}}{

Print a detailed description of the datatype; this is experimental}
}}

\seealso{
\code{\link[=H5T]{H5T}}
}
\author{
Holger Hoefling
}
