% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.hdsvm-methods.R
\name{coef.cv.hdsvm}
\alias{coef.cv.hdsvm}
\title{Extract Coefficients from a `cv.hdsvm` Object}
\usage{
\method{coef}{cv.hdsvm}(object, s = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{A fitted `cv.hdsvm()` object from which coefficients are to be extracted.}

\item{s}{Specifies the value(s) of the penalty parameter `lambda` for which coefficients are desired.
The default is `s = "lambda.1se"`, which corresponds to the largest value of `lambda` such that the
cross-validation error estimate is within one standard error of the minimum. Alternatively,
`s = "lambda.min"` can be used, corresponding to the minimum of the cross-validation error estimate.
If `s` is numeric, these are taken as the actual values of `lambda` to use.}

\item{...}{Not used.}
}
\value{
Returns the coefficients at the specified `lambda` values.
}
\description{
Retrieves coefficients from a cross-validated `hdsvm()` model, using the
stored `"hdsvm.fit"` object and the optimal `lambda` value determined during
cross-validation.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x1 <- matrix(rnorm(n / 2 * p, -0.25, 0.1), n / 2)
x2 <- matrix(rnorm(n / 2 * p, 0.25, 0.1), n / 2)
x <- rbind(x1, x2)
beta <- 0.1 * rnorm(p)
prob <- plogis(c(x \%*\% beta))
y <- 2 * rbinom(n, 1, prob) - 1
cv.fit <- cv.hdsvm(x, y, lam2 = 0.01)
coef(cv.fit, s = c(0.02, 0.03))
}
\seealso{
\code{\link{cv.hdsvm}}, \code{\link{predict.cv.hdsvm}}
}
