% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pima_meds}
\alias{pima_meds}
\title{Patient medications dataset}
\format{
A tibble data frame with 1,604 rows and 3 variables:
\describe{
  \item{patient_id}{Unique identifier, used to join \code{pima_diabetes}}
  \item{medication}{One of the six medications described above}
  \item{years_taken}{Numeric value indicating the duration the medication has
  been used}
}
}
\usage{
pima_meds
}
\description{
This is a companion dataset for \code{\link{pima_diabetes}}. The
\code{pima_diabetes} dataset is real; this dataset is synthetic. You can see
how it was generated here:
\url{https://docs.healthcare.ai/articles/site_only/best_levels.html#appendix-data-generation}.
Briefly, each patient in \code{pima_diabetes} is assigned 0-4 medications
from the following six: insulin and metformin are more common among
diabetics, prednisone and metoprolol are less common among diabetics, and
nexium and tiotropium are equally likely among diabetic and non-diabetic
patients. Each patient-medication has a \code{years_taken} value associated
with it, which is a random number drawn from an exponential distribution.
}
\seealso{
\code{\link{pima_diabetes}}
}
\keyword{datasets}
