% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paf.R
\name{paf}
\alias{paf}
\title{Population attributable fraction (PAF)}
\usage{
paf(
  pop = NULL,
  est,
  ordered_dimension,
  subgroup_order = NULL,
  setting_average = NULL,
  favourable_indicator,
  scaleval,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{pop}{The number of people within each subgroup.
Population size must be available for all subgroups.}

\item{est}{The subgroup estimate. Estimates must be
available for all subgroups.}

\item{ordered_dimension}{Records whether the dimension is ordered (1)
or not (0).}

\item{subgroup_order}{The order of subgroups in an increasing sequence,
if the dimension is ordered.}

\item{setting_average}{The reported setting average. Setting average must
be unique for each setting, year, indicator combination.
If population is not specified for all subgroups, the setting average is
used.}

\item{favourable_indicator}{Records whether the indicator is
favourable (1) or non-favourable (0). Favourable indicators measure
desirable health events where the ultimate goal is
to achieve a maximum level (such as skilled birth attendance).
Non-favourable indicators measure undesirable health events where
the ultimate goal is to achieve a minimum level (such as under-five
mortality rate).}

\item{scaleval}{The scale of the indicator. For example, the
scale of an indicator measured as a percentage is 100. The
scale of an indicator measured as a rate per 1000 population is 1000.}

\item{conf.level}{confidence level of the interval.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The estimated PAF value, corresponding estimated standard error,
and confidence interval as a \code{data.frame}.
}
\description{
The population attributable fraction (PAF) is a relative measure
of inequality that shows the potential improvement in the average
of an indicator, in relative terms, that could be achieved if
all population subgroups had the same level of the indicator as
a reference group.
}
\details{
PAF is calculated as the difference between the estimate for the
reference subgroup and the setting average, divided by the setting
average and multiplied by 100. For more information on this inequality
measure see Schlotheuber, A., & Hosseinpoor, A. R. (2022) below.

If the indicator is favourable and PAF < 0, then PAF is replaced with 0.
If the indicator is adverse and PAF > 0, then PAF is replaced with 0.
The selection of the reference subgroup depends on the characteristics
of the inequality dimension and the indicator type. It is the
most-advantaged subgroup for ordered dimensions. For non-ordered
dimensions, it is the subgroup with the highest estimate for favourable
indicators and is the subgroup with the lowest estimate for adverse
indicators.

\strong{Interpretation:} PAF assumes positive values for favourable
indicators and negative values for non-favourable (adverse) indicators.
The larger the absolute value of PAF, the higher the level of
inequality. PAF is zero if no further improvement can be achieved
(i.e., if all subgroups have reached the same level of the
indicator as the reference subgroup or surpassed that level).

\strong{Type of summary measure:} Complex; relative; weighted

\strong{Applicability:} Any

\strong{Warning:} The confidence intervals are approximate
and might be biased. See Walter S.D. (1978) below for
further information on the standard error formula.
}
\examples{
# example code
data(OrderedSample)
head(OrderedSample)
with(OrderedSample,
     paf(pop = population,
         est = estimate,
         ordered_dimension = ordered_dimension,
         subgroup_order = subgroup_order,
         favourable_indicator = favourable_indicator,
         scaleval = indicator_scale
         )
     )
}
\references{
Schlotheuber, A., & Hosseinpoor, A. R. (2022).
Summary measures of health inequality: A review of existing
measures and their application. International Journal of
Environmental Research and Public Health, 19 (6), 3697.

Walter, Stephen D. 1978. “Calculation of Attributable
Risks from Epidemiological Data.” International Journal of Epidemiology
7 (2): 175–82. https://doi.org/10.1093/IJE/7.2.175.
}
