% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-hai-fourier.R
\name{hai_fourier_augment}
\alias{hai_fourier_augment}
\title{Augment Function Fourier}
\usage{
hai_fourier_augment(
  .data,
  .value,
  .period,
  .order,
  .names = "auto",
  .scale_type = c("sin", "cos", "sincos")
)
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.value}{This is passed \code{\link[rlang:nse-defuse]{rlang::enquo()}} to capture the vectors you want
to augment.}

\item{.period}{The number of observations that complete a cycle}

\item{.order}{The fourier term order}

\item{.names}{The default is "auto"}

\item{.scale_type}{A character of one of the following: "sin","cos", or sincos" All
can be passed by setting the param equal to c("sin","cos","sincos")}
}
\value{
A augmented tibble
}
\description{
Takes a numeric vector(s) or date and will return a tibble of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "sincos"
\item c("sin","cos","sincos")
}
}
\details{
Takes a numeric vector or date and will return a vector of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "sincos"
\item c("sin","cos","sincos")
}

This function is intended to be used on its own in order to add columns to a
tibble.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out    = 10
by_unit    = "month"
start_date = as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a    = rnorm(len_out),
  b    = runif(len_out)
)

hai_fourier_augment(data_tbl, b, .period = 12, .order = 1, .scale_type = "sin")
hai_fourier_augment(data_tbl, b, .period = 12, .order = 1, .scale_type = "cos")

}
\seealso{
Other Augment Function: 
\code{\link{hai_fourier_discrete_augment}()},
\code{\link{hai_hyperbolic_augment}()},
\code{\link{hai_polynomial_augment}()},
\code{\link{hai_scale_zero_one_augment}()},
\code{\link{hai_winsorized_move_augment}()},
\code{\link{hai_winsorized_truncate_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
