% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-fourier-discrete.R
\name{hai_fourier_discrete_vec}
\alias{hai_fourier_discrete_vec}
\title{Vector Function Discrete Fourier}
\usage{
hai_fourier_discrete_vec(
  .x,
  .period,
  .order,
  .scale_type = c("sin", "cos", "sincos")
)
}
\arguments{
\item{.x}{A numeric vector}

\item{.period}{The number of observations that complete a cycle}

\item{.order}{The fourier term order}

\item{.scale_type}{A character of one of the following: "sin","cos","sincos"}
}
\value{
A numeric vector of 1's and 0's
}
\description{
Takes a numeric vector or date and will return a vector of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "sincos" This will do value = sin(x) * cos(x)
When either of these values falls below zero, then zero else one
}
}
\details{
Takes a numeric vector or date and will return a vector of one of the following:
\itemize{
\item "sin"
\item "cos"
\item "sincos"
}

The internal caluclation is straightforward:
\itemize{
\item \code{sin = sin(2 * pi * h * x)}, where \code{h = .order/.period}
\item \code{cos = cos(2 * pi * h * x)}, where \code{h = .order/.period}
\item \code{sincos = sin(2 * pi * h * x) * cos(2 * pi * h * x)} where \code{h = .order/.period}
}

This function can be used on its own. It is also the basis for the function
\code{\link[=hai_fourier_discrete_augment]{hai_fourier_discrete_augment()}}.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out    = 24
by_unit    = "month"
start_date = as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a    = rnorm(len_out),
  b    = runif(len_out)
)

vec_1 <- hai_fourier_discrete_vec(data_tbl$a, .period = 12, .order = 1, .scale_type = "sin")
vec_2 <- hai_fourier_discrete_vec(data_tbl$a, .period = 12, .order = 1, .scale_type = "cos")
vec_3 <- hai_fourier_discrete_vec(data_tbl$a, .period = 12, .order = 1, .scale_type = "sincos")

plot(data_tbl$b)
lines(vec_1, col = "blue")
lines(vec_2, col = "red")
lines(vec_3, col = "green")

}
\seealso{
Other Vector Function: 
\code{\link{hai_fourier_vec}()},
\code{\link{hai_hyperbolic_vec}()},
\code{\link{hai_scale_zero_one_vec}()},
\code{\link{hai_winsorized_move_vec}()},
\code{\link{hai_winsorized_truncate_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
