% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-hai-kurtosis.R
\name{hai_kurtosis_vec}
\alias{hai_kurtosis_vec}
\title{Compute Kurtosis of a Vector}
\usage{
hai_kurtosis_vec(.x)
}
\arguments{
\item{.x}{A numeric vector of length four or more.}
}
\value{
The kurtosis of a vector
}
\description{
This function takes in a vector as it's input and will return the kurtosis
of that vector. The length of this vector must be at least four numbers. The
kurtosis explains the sharpness of the peak of a distribution of data.

\verb{((1/n) * sum(x - mu\})^4) / ((()1/n) * sum(x - mu)^2)^2}
}
\details{
A function to return the kurtosis of a vector.
}
\examples{
hai_kurtosis_vec(rnorm(100, 3, 2))

}
\seealso{
\url{https://en.wikipedia.org/wiki/Kurtosis}

Other Vector Function: 
\code{\link{hai_fourier_discrete_vec}()},
\code{\link{hai_fourier_vec}()},
\code{\link{hai_hyperbolic_vec}()},
\code{\link{hai_scale_zero_one_vec}()},
\code{\link{hai_scale_zscore_vec}()},
\code{\link{hai_skewness_vec}()},
\code{\link{hai_winsorized_move_vec}()},
\code{\link{hai_winsorized_truncate_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
