% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/part_surv.R
\name{define_part_surv}
\alias{define_part_surv}
\alias{define_part_surv_}
\title{Define Partitioned Survival}
\usage{
define_part_surv(pfs, os, state_names, terminal_state = FALSE, km_limit = 0,
  cycle_length = 1)

define_part_surv_(pfs, os, state_names, km_limit = 0, cycle_length = 1)
}
\arguments{
\item{pfs, os}{Either results from 
\code{\link[flexsurv]{flexsurvreg}} or 
\code{\link{define_survival}}.}

\item{state_names}{named character vector, length 3 or 4.
State names for progression-free state, progression, 
(optionally terminal) and death respectively. Elements 
should be named \code{"progression_free"}, 
\code{"progression"}, (optionally \code{"terminal"}), 
and \code{"death"}. See examples.}

\item{terminal_state}{Should a terminal state be 
included? Only used when state names are not provided.}

\item{km_limit}{Up to what time should Kaplan-Meier
estimates be used? Model predictions will be used
thereafter. Either a length 2 vector (for \code{pfs}
and \code{os} respectively) or a single values (used
for both distributions).}

\item{cycle_length}{The value of a Markov cycle in
absolute time units.}
}
\value{
A \code{part_surv} object.
}
\description{
Define a partitioned survival model with progression-free
survival and overall survival.
}
\examples{
dist_pfs <- define_survival("exp", rate = 1)
dist_os <- define_survival("exp", rate = .5)

define_part_surv(
  pfs = dist_pfs,
  os = dist_os,
  state_names = c(
    progression_free = "A",
    progression = "B",
    terminal = "C",
    death = "D"
  )
)
# identical to:
define_part_surv(
  pfs = dist_pfs,
  os = dist_os,
  terminal_state = TRUE
)

}
