% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_eval.R
\name{eval_surv}
\alias{eval_surv}
\alias{eval_surv.survfit}
\alias{eval_surv.flexsurvreg}
\alias{eval_surv.surv_model}
\alias{eval_surv.surv_projection}
\alias{eval_surv.surv_pooled}
\alias{eval_surv.surv_ph}
\alias{eval_surv.surv_aft}
\alias{eval_surv.surv_po}
\alias{eval_surv.surv_add_haz}
\alias{eval_surv.surv_dist}
\title{Evaluate Survival Distributions}
\usage{
eval_surv(x, time, cycle_length = 1, type = c("prob", "surv"), ...)

\method{eval_surv}{survfit}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{flexsurvreg}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_model}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_projection}(x, time, cycle_length = 1,
  type = c("prob", "surv"), ...)

\method{eval_surv}{surv_pooled}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_ph}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_aft}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_po}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_add_haz}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)

\method{eval_surv}{surv_dist}(x, time, cycle_length = 1, type = c("prob",
  "surv"), ...)
}
\arguments{
\item{x}{A survival distribution object}

\item{time}{The \code{model_time} or \code{state_time} for which
to predict.}

\item{cycle_length}{The value of a Markov cycle in
absolute time units.}

\item{type}{either \code{prob}, for transition probabilities,
or \code{surv}, for survival}

\item{...}{arguments passed to methods.}
}
\value{
Returns either the survival probalities or
conditional probabilities of event for each cycle.
}
\description{
Generate either survival probabilities or conditional
probabilities of event for each model cycle.
}
\details{
The results of \code{compute_surv()} are memoised for
\code{options("heemod.memotime")} (default: 1 hour) to
increase resampling performance.
}
\keyword{internal}
