% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{probability}
\alias{probability}
\alias{rescale_prob}
\alias{prob_to_prob}
\alias{rate_to_prob}
\alias{or_to_prob}
\alias{rr_to_prob}
\title{Convenience Functions to Compute Probabilities}
\usage{
rescale_prob(p, to = 1, from = 1)

prob_to_prob(...)

rate_to_prob(r, to = 1, per = 1)

or_to_prob(or, p)

rr_to_prob(rr, p)
}
\arguments{
\item{p}{Probability.}

\item{to}{Compute probability for that timeframe.}

\item{from}{Timeframe of the original probability.}

\item{...}{For deprecated functions.}

\item{r}{Rate.}

\item{per}{Number of person-time corresponding to the
rate.}

\item{or}{Odds ratio.}

\item{rr}{Relative risk.}
}
\value{
A probability.
}
\description{
These convienience functions make it easier to compute
transition probabilities from indidence rates, OR, RR, or
probabilities estimated on a different timeframe.
}
\examples{
# convert 5-year probability 
# to 1-year probability
rescale_prob(p = .65, from = 5)

# convert 1-year probability 
# to 1-month probability
rescale_prob(p = .5, to = 1/12)

# convert rate per 1000 PY
# to 5-year probability
rate_to_prob(r = 162, per = 1000, to = 5)

# convert OR to probability
or_to_prob(or = 1.9, p = .51)

# convert RR to probability
rr_to_prob(rr = 1.9, p = .51)
}
