% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans_procedure.R
\name{kmeans_procedure}
\alias{kmeans_procedure}
\title{K-means procedure}
\usage{
kmeans_procedure(
  data,
  columns,
  threshold_min,
  threshold_max,
  verbose = FALSE,
  seed = 42
)
}
\arguments{
\item{data}{a R data frame.}

\item{columns}{a vector of columns names of the data frame on which we perform the kmeans algorithm. These features have to be numeric.}

\item{threshold_min}{an integer. It represents the minimum size for cluster.}

\item{threshold_max}{an integer. It represents the maximum size fo cluster.}

\item{verbose}{a boolean. If set to TRUE print the current state of the procedure (by default set to FALSE).}

\item{seed}{an integer. This represents the seed for the random call (if we want the output to be reproducible).}
}
\value{
a R data frame. This contains the id of the original data frame and a column `cluster` representing
the cluster to which the observation belongs to.
}
\description{
This function allows to perform k-means clustering with constrained on the size of clusters
}
\examples{
library(dplyr)
data <- iris \%>\% select(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width)
features <- colnames(data)
result <- kmeans_procedure(data = data, columns = features, threshold_min = 2, threshold = 10,
verbose=FALSE, seed=10)
}
\references{
Link to the author's github package repository:
\url{https://www.github.com/Redcart/helda}
}
\author{
Simon CORDE
}
\keyword{cluster}
\keyword{kmeans}
\keyword{sizes}
