% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharter.R
\name{highchart}
\alias{highchart}
\title{Create a Highcharts chart widget}
\usage{
highchart(hc_opts = list(), theme = getOption("highcharter.theme"),
  type = "chart", width = NULL, height = NULL, elementId = NULL,
  debug = FALSE)
}
\arguments{
\item{hc_opts}{A \code{list} object containing options defined as 
\url{http://api.highcharts.com/highcharts}.}

\item{theme}{A \code{hc_theme} class object}

\item{type}{A character value to set if use Highchart, Highstock or
Highmap. Options are \code{"chart"}, \code{"stock"} and \code{"map"}.}

\item{width}{A numeric input in pixels.}

\item{height}{A numeric input in pixels.}

\item{elementId}{Use an explicit element ID for the widget.}

\item{debug}{A boolean value if you want to print in the browser console the 
parameters given to \code{highchart}.}
}
\description{
This function creates a Highchart chart using \pkg{htmlwidgets}. The
widget can be rendered on HTML pages generated from R Markdown, Shiny, or
other applications.
}

