% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-helpers.R
\name{tooltip_chart}
\alias{tooltip_chart}
\title{Helper to create charts in tooltips.}
\usage{
tooltip_chart(accesor = NULL, hc_opts = NULL, width = 250,
  height = 150)
}
\arguments{
\item{accesor}{A string indicating the name of the column where the data is.}

\item{hc_opts}{A list of options using the  \url{http://api.highcharts.com/highcharts}
syntax.}

\item{width}{A numeric input in pixels indicating the with of the tooltip.}

\item{height}{A numeric input in pixels indicating the height of the tooltip.}
}
\description{
Helper to create charts in tooltips.
}
\details{
This function needs to be used in the \code{pointFormatter} argument
inside of \code{hc_tooltip} function an \code{useHTML = TRUE} option.
}
\examples{


\dontrun{
require(dplyr)
require(purrr)
require(tidyr)
require(gapminder)
data(gapminder, package = "gapminder")

gp <- gapminder \%>\%
  arrange(desc(year)) \%>\%
  distinct(country, .keep_all = TRUE)

gp2 <- gapminder \%>\%
  nest(-country) \%>\%
  mutate(data = map(data, mutate_mapping, hcaes(x = lifeExp, y = gdpPercap), drop = TRUE),
         data = map(data, list_parse)) \%>\%
  rename(ttdata = data)

gptot <- left_join(gp, gp2)

hc <- hchart(
        gptot,
        "point",
        hcaes(
          lifeExp,
          gdpPercap,
          name = country,
          size = pop,
          group = continent
          )
       ) \%>\%
  hc_yAxis(type = "logarithmic")

hc \%>\%
  hc_tooltip(useHTML = TRUE, pointFormatter = tooltip_chart(accesor = "ttdata"))

hc \%>\%
  hc_tooltip(useHTML = TRUE, pointFormatter = tooltip_chart(
    accesor = "ttdata",
    hc_opts = list(chart = list(type = "column"))
  ))

hc \%>\%
  hc_tooltip(
    useHTML = TRUE,
    positioner = JS("function () { return { x: this.chart.plotLeft + 10, y: 10}; }"),
    pointFormatter = tooltip_chart(
      accesor = "ttdata",
      hc_opts = list(
        title = list(text = "point.country"),
        xAxis = list(title = list(text = "lifeExp")),
        yAxis = list(title = list(text = "gdpPercap")))
      )
    )

hc \%>\%
  hc_tooltip(
    useHTML = TRUE,
    pointFormatter = tooltip_chart(
      accesor = "ttdata",
      hc_opts = list(
        legend = list(enabled = TRUE),
        series = list(list(color = "gray", name = "point.name"))
      )
    )
  )
 }

}
