% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sampleTData}
\alias{sampleTData}
\title{Sample of cleaned trades for stock XXX for 2 days}
\format{
A data.table object.
}
\usage{
sampleTData
}
\description{
A \code{data.table} object containing the trades for the imaginary stock XXX for 2 days, in the typical NYSE TAQ database format.
This is the cleaned version of the data sample \code{\link{sampleTDataRaw}}, using \code{tradesCleanup}.
}
\examples{
\dontrun{
# The code to create the sampleTData dataset from raw data is
sampleQData <- quotesCleanup(qDataRaw = sampleQDataRaw,
                                         exchanges = "N", type = "standard", report = FALSE)

tradesAfterFirstCleaning <- tradesCleanup(tDataRaw = sampleTDataRaw, 
                                          exchanges = "N", report = FALSE)

sampleTData <- tradesCleanupUsingQuotes(
  tData = tradesAfterFirstCleaning,
  qData = sampleQData,
  lagQuotes = 0)[, c("DT", "SYMBOL", "PRICE", "SIZE")]
# Only some columns are included. These are the ones that were historically included.
}

}
\keyword{datasets}
