% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driftBursts.R
\name{plot.DBH}
\alias{plot.DBH}
\title{Plotting method for \code{DBH} objects}
\usage{
\method{plot}{DBH}(x, ...)
}
\arguments{
\item{x}{an object of class \code{DBH}}

\item{...}{optional arguments, see details}
}
\description{
Plotting method for \code{DBH} objects
}
\details{
The plotting method has the following optional parameters:
\itemize{
\item{\code{pData}}{ A \code{data.table} or an \code{xts} object, containing the prices and timestamps of the data used to calculate the test statistic.
If specified, and \code{which = "tStat"}, the price will be shown on the right y-axis along with the test statistic}
\item{\code{which}}{ A string denoting which of four plots to make. \code{"tStat"} denotes plotting the test statistic. \code{"sigma"} denotes plotting the
estimated volatility process. \code{"mu"} denotes plotting the estimated drift process. If \code{which = c("sigma", "mu")} or \code{which = c("mu", "sigma")},
both the drift and volatility processes are plotted. CaPiTAlizAtIOn doesn't matter}
}
}
\examples{
\dontshow{if (!grepl("debian", sessionInfo()["platform"], fixed = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{data.table::setDTthreads(2)}
# Testing every 60 seconds after 09:15:00
DBH <- driftBursts(sampleTDataEurope, testTimes = seq(32400 + 900, 63000, 60), preAverage = 2, 
                    ACLag = -1L, meanBandwidth = 300L, varianceBandwidth = 900L)
plot(DBH)
plot(DBH, pData = sampleTDataEurope)
plot(DBH, which = "sigma")
plot(DBH, which = "mu")
plot(DBH, which = c("sigma", "mu"))
\dontshow{\}) # examplesIf}
}
\author{
Emil Sjoerup
}
