% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rosters.R
\name{get_rosters}
\alias{get_rosters}
\title{Get team rosters from hockey-reference.com}
\usage{
get_rosters(
  team = "all",
  season = as.numeric(format(Sys.Date() + 184, "\%Y")),
  include_stats = FALSE
)
}
\arguments{
\item{team}{A character vector of team names or abbreviations}

\item{season}{An integer value denoting the end year of the season to scrape}

\item{include_stats}{Set to TRUE to return player counting stats for the season}
}
\value{
A tibble containing the latest roster for the specified team(s)
in the specified season
}
\description{
Get the latest roster for any team from hockey-reference.com.
You may enter either the team abbreviation or the full team name. Seasons
must be 4-digit integers denoting the end-year of the regular season
desired (ie 2021-22 season should be 2022)\cr\cr
Please note that this uses the hockey-reference.com team abbreviations,
the oddest of which is Vegas being 'VEG' instead of 'VGK'. If you are
unsure of the team abbreviation, enter the full team name instead, or
check the full team abbreviations data and filter to your desired season:\cr\cr
\code{filter(team_abbr_yearly, season_short == {season})}
}
\examples{
\dontrun{
get_rosters("SEA", 2022)
}
}
