% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleo.R
\name{get_paleo}
\alias{get_paleo}
\title{Download and plot essential climate data}
\usage{
get_paleo(use_cache = TRUE, write_cache = getOption("hs_write_cache"))
}
\arguments{
\item{use_cache}{(boolean) Return cached data if available, defaults to TRUE. Use FALSE to fetch updated data.}

\item{write_cache}{(boolean) Write data to cache, defaults to FALSE. Use TRUE to write data to cache for later use. Can also be set using options(hs_write_cache=TRUE)}
}
\value{
Invisibly returns a tibble with the age of the ice (years before C.E.), carbon dioxide (ppm) and temperature (degrees C).

\code{get_paleo} invisibly returns a tibble with Vostok ice core data: the age of the ice (years before C.E.), carbon dioxide (ppm) and temperature (degrees C).

Data are from: Barnola J; Raynaud D; Lorius C; Barkov N  (2003): Historical Carbon Dioxide Record from the Vostok Ice Core (417,160 - 2,342 years BP) and
Petit J R ; Raynaud D ; Lorius C ; Delaygue G ; Jouzel J ; Barkov N I ; Kotlyakov V M  (2000): Historical Isotopic Temperature Record from the Vostok Ice Core. CDIAC.
}
\description{
Retrieves historical carbon dioxide and temperature records from the Vostok ice core during the past 420,000 years.
Source of data is the U.S. Department of Energy’s (DOE) Environmental System Science Data Infrastructure for a Virtual Ecosystem (ESS-DIVE).
\url{https://ess-dive.lbl.gov/} and \url{https://cdiac.ess-dive.lbl.gov/trends/co2/vostok.html}
}
\examples{
\donttest{
# Fetch Vostok paleo carbon and temperature data from cache if available:
vostok <- get_paleo()
#
# Force cache refresh:
vostok <- get_paleo(use_cache=FALSE)
#
# Review cache contents and last update dates:
hockeystick_cache_details()
#
# Plot output using package's built-in ggplot2 settings
plot_paleo(vostok) }

}
\references{
\itemize{
\item Historical Carbon Dioxide Record from the Vostok Ice Core (US Dept of Energy): \url{https://cdiac.ess-dive.lbl.gov/trends/co2/vostok.html}
\item Petit J R ; Raynaud D ; Lorius C ; Delaygue G ; Jouzel J ; Barkov N I ; Kotlyakov V M  (2000): Historical Isotopic Temperature Record from the Vostok Ice Core. CDIAC. doi:10.3334/CDIAC/CLI.006. \url{https://data.ess-dive.lbl.gov/view/doi:10.3334/CDIAC/CLI.006}
\item Barnola J ; Raynaud D ; Lorius C ; Barkov N  (2003): Historical Carbon Dioxide Record from the Vostok Ice Core (417,160 - 2,342 years BP). None. doi:10.3334/CDIAC/ATG.009 \url{https://data.ess-dive.lbl.gov/view/doi:10.3334/CDIAC/ATG.009}
}
}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
