% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{profile.hopit}
\alias{profile.hopit}
\title{Calculate the log likelihood profile for the fitted \code{hopit} model}
\usage{
\method{profile}{hopit}(fitted, ..., scope = 0.15, steps = 101)
}
\arguments{
\item{fitted}{a \code{hopit} object (a fitted model).}

\item{...}{unused now.}

\item{scope}{a value (fraction) defining the plotting range for a coefficient.
The range is \code{c(coef \* (1-scope), coef \* (1+scope))}.}

\item{steps}{at how many equally spaced points the log likelihood
function is calculated for each coefficient.}
}
\description{
Calculate the log likelihood profile for the fitted \code{hopit} model
}
\examples{
\donttest{
# DATA
data(healthsurvey)

# the order of response levels decreases from the best health to
# the worst health; hence the hopit() parameter decreasing.levels
# is set to TRUE
levels(healthsurvey$health)

# Example 1 ---------------------

# fitting the model:
model1 <- hopit(latent.formula = health ~ hypertension + high_cholesterol +
                heart_attack_or_stroke + poor_mobility + very_poor_grip +
                depression + respiratory_problems +
                IADL_problems + obese + diabetes + other_diseases,
              thresh.formula = ~ sex + ageclass + country,
              decreasing.levels = TRUE,
              control = list(trace = FALSE),
              data = healthsurvey)

# check the fit using the profile function (at 51 points)
pr <- profile(model1, steps = 51)
print(pr, plotf = FALSE)

# plot profile
plot(pr, relative = FALSE)

# alternative plot
plot(pr, relative = TRUE)
}
}
\seealso{
\code{\link{plot.profile.hopit}}, \code{\link{print.profile.hopit}},
\code{\link{hopit}}
}
\author{
Maciej J. Danko
}
\keyword{internal}
