% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{howlerCurrentTrack}
\alias{howlerCurrentTrack}
\alias{howlerSeekTime}
\alias{howlerDurationTime}
\title{Current Track}
\usage{
howlerCurrentTrack(id, ...)

howlerSeekTime(id, ...)

howlerDurationTime(id, ...)
}
\arguments{
\item{id}{ID given to the current track label. For it to work with the \code{\link{howler}}, the ID
must match that of the \code{howler}.}

\item{...}{Other attributes to give to the HTML tag.}
}
\value{
A \code{div} tag that will be linked to the \code{\link{howler}} to show the current track.
}
\description{
A way to display track information in the UI without having to communicate with the server.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "howler.js Player",
    howler(elementId = "sound", "audio/sound.mp3"),
    howlerCurrentTrack("sound"),
    p(
      howlerSeekTime("sound"),
      "/",
      howlerDurationTime("sound")
    ),
    howlerPlayPauseButton("sound")
  )

  server <- function(input, output, session) {
  }

  shinyApp(ui, server)
}

}
