% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtIndex.R
\name{rtIndex}
\alias{rtIndex}
\title{Create a full index object by repeat transaction approach}
\usage{
rtIndex(trans_df, ...)
}
\arguments{
\item{trans_df}{data.frame of transactions.  Can be a 'hpidata' or an 'rtdata' object.}

\item{...}{Additional Arguments}
}
\value{
`hpi`` object.  S3 list with:
\describe{
\item{data}{`hpidata` object}
\item{model}{`hpimodel` object}
\item{index}{`hpiindex` object}
}
}
\description{
Wrapper to create index object via entire repeat transaction approach
}
\section{Further Details}{

Additional argument need to provide necessary argument for create `hpidata` objects if
the `trans_df` object is not of that class.
}

\examples{

 # Load data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

}
