% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{ancestor.find}
\alias{ancestor.find}
\title{Find ancestor nodes for a node in directed acyclic graph.}
\usage{
ancestor.find(index, map, n.nodes)
}
\arguments{
\item{index}{Index of the node currently at.}

\item{map}{Matrix of \code{n.edges}-by-\code{2} dimension, where \code{n.edges}
is the number of directed edges in DAG. The first column has indices of
nodes that edges directing from, whereas the second column gives the indices
of nodes the corresponding edges directing towards.}

\item{n.nodes}{Number of nodes in DAG.}
}
\value{
Returns a length-\code{n.nodes} vector of binary values for which
1 indicates the corresponding node is an ancestor node and 0 indicates it is not.
}
\description{
Recursively finds all ancestor nodes in DAG for node with the given index.
}
