% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols_regimes.R
\name{ols_regimes}
\alias{ols_regimes}
\alias{coef.ols_regimes}
\alias{vcov.ols_regimes}
\alias{print.ols_regimes}
\alias{summary.ols_regimes}
\alias{print.summary.ols_regimes}
\title{Estimation of spatial regimes models}
\usage{
ols_regimes(formula, data, listw, rgv, het, cl)

\method{coef}{ols_regimes}(object, ...)

\method{vcov}{ols_regimes}(object, ...)

\method{print}{ols_regimes}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{ols_regimes}(object, ...)

\method{print}{summary.ols_regimes}(x, digits = max(5, getOption("digits") - 3), ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x_f | x_v | wx | h_f | h_v | wh} where \code{y} is the dependent variable, \code{x_f} are the regressors that do not vary by regimes,  \code{x_v} are the regressors that vary by regimes, \code{wx} are the spatially lagged regressors, \code{h_f} are the instruments that do not vary by regimes,  \code{h_v} are the instruments that vary by regimes, \code{wh} are the spatially lagged instruments.}

\item{data}{the data of class \code{data.frame}.}

\item{listw}{a spatial weighting matrix of class \code{listw}, \code{matrix} or \code{Matrix}}

\item{rgv}{an object of class \code{formula} to identify the regime variables}

\item{het}{heteroskedastic variance-covariance matrix}

\item{cl}{record calls}

\item{object}{an object of class ols_regimes}

\item{...}{additional arguments}

\item{x}{an object of class ols_regimes}

\item{digits}{number of digits}
}
\value{
An object of class \code{"ols_regimes"}. A \code{list} of four elements. The first element of the \code{list} contains the estimation results. The other elements are needed for printing.
}
\description{
Estimation of spatial regimes models
}
\examples{
data("natreg")
data("ws_6")

split  <- ~ REGIONS

form <-  HR90  ~ MA90 -1 |  PS90 +
RD90 + UE90 | MA90 | MA90 -1 |  PS90 +
RD90 + FH90 + FP89 + GI89 | 0

form1 <-  HR90  ~ MA90 -1 |  PS90 +
RD90 + UE90 | MA90 | MA90 -1 |  PS90 +
RD90 + FH90 + FP89 + GI89 | GI89

form2 <-  HR90  ~ MA90 -1 |  PS90 +
RD90 + UE90 | MA90 + RD90 | MA90 -1 |  PS90 +
RD90 + FH90 + FP89 + GI89 | GI89

mod <- spregimes(formula = form, data = natreg,
rgv = split, listw = ws_6, model = "ols")
summary(mod)

mod1 <- spregimes(formula = form1, data = natreg,
rgv = split, listw = ws_6, model = "ols")
summary(mod1)

mod2 <- spregimes(formula = form2, data = natreg,
rgv = split, listw = ws_6, model = "ols")
summary(mod2)
}
