% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsrecombi.R
\name{geneticPosition}
\alias{geneticPosition}
\title{Estimation of genetic position}
\usage{
geneticPosition(final, exclude = NULL, threshold = 0.05)
}
\arguments{
\item{final}{table of results produced by \code{editraw} with pairwise
estimates of recombination rate between p SNPs within chromosome; minimum
required data frame with columns \code{SNP1}, \code{SNP2} and \code{theta}}

\item{exclude}{optional vector (LEN q) of SNPs to be excluded (e.g.,
candidates of misplaced SNPs)}

\item{threshold}{optional value; recombination rates <= threshold are
considered for smoothing}
}
\value{
vector (LEN p) of genetic positions of SNPs (in cM)
}
\description{
Estimation of genetic positions (in centi Morgan)
}
\details{
Smoothing of recombination rates (theta) <= 0.05 via quadratic
  optimization provides an approximation of genetic distances (in Morgan)
  between SNPs. The cumulative sum * 100 yields the genetic positions in cM.

  The minimization problem \code{(theta - D d)^2} is solved s.t. d > 0 where
  d is the vector of genetic distances between adjacent markers but theta is
  not restricted to adjacent markers. The incidence matrix D contains 1's for
  those intervals contributing to the total distance relevant for each theta.

  Estmates of theta = 1e-6 are neglected as these values coincide with start
  values and indicate that (because of a very flat likelihood surface) no
  meaningful estimate of recombination rate has been obtained.
}
\examples{
  ### test data
  data(targetregion)
  ### make list for paternal half-sib families
  hap <- makehaplist(daughterSire, hapSire)
  ### parameter estimates on a chromosome
  res <- hsrecombi(hap, genotype.chr, map.chr$SNP)
  ### post-processing to achieve final and valid set of estimates
  final <- editraw(res, map.chr)
  ### approximation of genetic positions
  pos <- geneticPosition(final)
}
