% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lump_tissues.R
\name{lump_tissues}
\alias{lump_tissues}
\title{Lump tissue parameters}
\usage{
lump_tissues(
  Ktissue2pu.in,
  parameters = NULL,
  tissuelist = NULL,
  species = "Human",
  tissue.vols = NULL,
  tissue.flows = NULL,
  model = "pbtk",
  suppress.messages = FALSE
)
}
\arguments{
\item{Ktissue2pu.in}{List of partition coefficients from
predict_partitioning_schmitt.}

\item{parameters}{A list of physiological parameters including flows and
volumes for tissues in \code{tissuelist}}

\item{tissuelist}{Manually specifies compartment names and tissues, which
override the standard compartment names and tissues that are usually
specified in a model's associated modelinfo file. Remaining tissues in the
model's associated \code{alltissues} listing are lumped in the rest of the body.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{tissue.vols}{A list of volumes for tissues in \code{tissuelist}}

\item{tissue.flows}{A list of flows for tissues in \code{tissuelist}}

\item{model}{Specify which model (and therefore which tissues) are being 
considered}

\item{suppress.messages}{Whether or not the output message is suppressed.}
}
\value{
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells
to unbound concentration in plasma.} \item{Krest2pu}{Ratio of concentration
of chemical in rest of body tissue to unbound concentration in plasma.}
\item{Vrestc}{ Volume of the rest of the body per kg body weight, L/kg BW.}
\item{Vliverc}{ Volume of the liver per kg body weight, L/kg BW.}
\item{Qtotal.liverf}{Fraction of cardiac output flowing to the gut and
liver, i.e. out of the liver.} \item{Qgutf}{Fraction of cardiac output
flowing to the gut.} \item{Qkidneyf}{Fraction of cardiac output flowing to
the kidneys.}
}
\description{
This function takes the parameters from predict_partitioning_schmitt and 
lumps the partition coefficients along with the volumes and flows based on 
the given tissue list. It is useful in Monte Carlo simulation of individual
partition coefficients when calculating the rest of body partition
coefficient.
}
\details{
This function returns the flows, volumes, and partition coefficients for the
lumped tissues specified in tissue list Ktissue2plasma -- tissue to free
plasma concentration partition coefficients for every tissue specified by 
Schmitt (2008) (the tissue.data table) tissuelist -- a list of character 
vectors, the name of each entry in the list is its own compartment.
The tissues in the alltissues vector are the Schmitt (2008) tissues that are
to be considered in the lumping process. The tissuelist can also be manually
specified for alternate lumping schemes: for example,
tissuelist<-list(Rapid=c("Brain","Kidney")) specifies the flow.col and
vol.col in the tissuedata.table.
}
\examples{

pcs <- predict_partitioning_schmitt(chem.name='bisphenola')
tissuelist <- list(liver=c("liver"),kidney=c("kidney"),lung=c("lung"),gut=c("gut")
,muscle.bone=c('muscle','bone'))
lump_tissues(pcs,tissuelist=tissuelist)

}
\references{
Pearce, Robert G., et al. "Evaluation and calibration of 
high-throughput predictions of chemical distribution to tissues." Journal of
pharmacokinetics and pharmacodynamics 44.6 (2017): 549-565.
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
