% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_1comp.R
\name{parameterize_1comp}
\alias{parameterize_1comp}
\title{Parameters for a one compartment (empirical) toxicokinetic model}
\usage{
parameterize_1comp(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = FALSE,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  regression = TRUE,
  restrictive.clearance = TRUE,
  well.stirred.correction = TRUE,
  suppress.messages = FALSE,
  clint.pvalue.threshold = 0.05,
  minimum.Funbound.plasma = 1e-04,
  class.exclude = TRUE,
  Caco2.options = list(),
  ...
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing rat values with human values if
true.}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts volume of distribution) when set to TRUE (Default).}

\item{adjusted.Clint}{Uses Kilford et al. (2008) hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients in volume of distribution calculation.}

\item{restrictive.clearance}{In calculating elimination rate and hepatic
bioavailability, protein binding is not taken into account (set to 1) in
liver clearance if FALSE.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic
clearance for well-stirred model if TRUE.  This assumes clearance relative
to amount unbound in whole blood instead of plasma, but converted to use
with plasma concentration.}

\item{suppress.messages}{Whether or not to suppress messages.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-value greater than the threshold are
set to zero.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{class.exclude}{Exclude chemical classes identified as outside of 
domain of applicability by relevant modelinfo_[MODEL] file (default TRUE).}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.Pab.default = 1.6,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fbio}} for further details.}

\item{...}{Additional arguments, not currently used.}
}
\value{
\item{Vdist}{Volume of distribution, units of L/kg BW.}
\item{Fabsgut}{Fraction of the oral dose absorbed and surviving gut metabolism, i.e. the 
fraction of the dose that enters the gutlumen.} \item{kelim}{Elimination rate, units of
1/h.} \item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{Fabsgut}{Fraction of the oral dose absorbed, i.e. the fraction of the
dose that enters the gutlumen.} 
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte 
assay using the method of Kilford et al. (2008)} 
\item{kelim}{Elimination rate, units of 1/h.} 
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{kgutabs}{Rate chemical is absorbed, 1/h.}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.}
\item{MW}{Molecular Weight, g/mol.} 
\item{Rblood2plasma}{The ratio of the concentration of the chemical in the 
blood to the concentration in the plasma. Not used in calculations but 
included for the conversion of plasma outputs.} 
\item{hepatic.bioavailability}{Fraction of dose remaining after
first pass clearance, calculated from the corrected well-stirred model.}
\item{BW}{Body Weight, kg.}
}
\description{
This function initializes the parameters needed in the function solve_1comp.
Volume of distribution is estimated by using a modified Schmitt (2008) method
to predict tissue particition coefficients (Pearce et al., 2017) and then
lumping the compartments weighted by tissue volume:
}
\details{
\if{latex}{
\eqn{V_{d,steady-state} = \Sigma_{i\in tissues}K_{i}V_{i} + V_{plasma}}
}
\if{html}{
V_d,steady-state = Sum over all tissues (K_i * V_i) + V_plasma
}

where K_i is the tissue:unbound plasma concentration partition coefficient
for tissue i.
}
\examples{

 parameters <- parameterize_1comp(chem.name='Bisphenol-A',species='Rat')
 parameters <- parameterize_1comp(chem.cas='80-05-7',
                                  restrictive.clearance=FALSE,
                                  species='rabbit',
                                  default.to.human=TRUE)
 out <- solve_1comp(parameters=parameters,days=1)

}
\references{
\insertRef{pearce2017httk}{httk}

\insertRef{schmitt2008general}{httk}

\insertRef{pearce2017evaluation}{httk}

\insertRef{kilford2008hepatocellular}{httk}
}
\seealso{
\code{\link{solve_1comp}}

\code{\link{calc_analytic_css_1comp}}

\code{\link{calc_vdist}}

\code{\link{parameterize_steadystate}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{1compartment}
\keyword{Parameter}
