% Generated by roxygen2 (4.0.1): do not edit by hand
\name{http_error}
\alias{http_error}
\alias{stop_for_status}
\alias{warn_for_status}
\title{Take action on http error.}
\usage{
stop_for_status(x)

warn_for_status(x)
}
\arguments{
\item{x}{a request object}
}
\value{
If request was successful, an invisible \code{TRUE}. Otherwise,
  raised a classed http error or warning, as generated by
  \code{\link{http_condition}}
}
\description{
Converts http errors to R errors or warnings - these should always
be used whenever you're creating requests inside a function, so
that the user knows why a request has failed.
}
\examples{
x <- GET("http://httpbin.org/status/200")
stop_for_status(x) # nothing happens
warn_for_status(x)

x <- GET("http://httpbin.org/status/300")
\dontrun{stop_for_status(x)}
warn_for_status(x)

x <- GET("http://httpbin.org/status/404")
\dontrun{stop_for_status(x)}
warn_for_status(x)
}
\seealso{
\code{\link{http_status}} and
  \code{http://en.wikipedia.org/wiki/Http_status_codes} for more information
  on http status codes.

Other response methods: \code{\link{content}},
  \code{\link{parsed_content}}, \code{\link{text_content}};
  \code{\link{http_status}}; \code{\link{response}};
  \code{\link{url_ok}}; \code{\link{url_success}}
}

