% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_exposure.R
\name{multi_county_wind}
\alias{multi_county_wind}
\title{Hurricane exposure by wind for communities}
\usage{
multi_county_wind(communities, start_year, end_year, wind_limit)
}
\arguments{
\item{communities}{A dataframe with the FIPS codes for all counties within
each community. It must include columns with a column identifier
(\code{commun}) and with the FIPS codes of counties included in each
community (\code{fips}). See the example code.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{wind_limit}{A numeric vector of length one giving the minimum
wind speed (in meters per second) or duration of winds of 20 m / s or more
(in minutes) to use in the filter. The units of this variable will depend on
the user's choice for the \code{wind_var} parameter. If the Extended Best
Tracks wind radii are used as the source of the wind data, the sustained
winds will only be available for cutpoints of 34 knots, 50 knots, and 64
knots, so these values should be used (e.g., to get all counties with winds of
34 knots or higher, you could use \code{wind_limit = 17.4}, with the limit
given as a value just below 34 knots in the units meters per second).}
}
\value{
Returns the same type dataframe as \code{county_rain},
   but with storms listed by community instead of county.
}
\description{
This function takes a dataframe with multi-county communities and returns a
community-level dataframe of "exposed" storms, based on the highest of the
maximum sustained wind speed for each county in the community.
}
\note{
This function currently will only input a threshold for the sustained wind
   metric. If you would like to use gust winds or duration of winds, you will need
   to use the \code{county_wind} function to pull storms and aggregate to the
   multi-county community level yourself.
}
\examples{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

communities <- data.frame(community_name = c(rep("ny", 6), "no", "new"),
                         fips = c("36005", "36047", "36061",
                                  "36085", "36081", "36119",
                                  "22071", "51700"))
wind_df <- multi_county_wind(communities = communities,
                                     start_year = 1988, end_year = 2005,
                                     wind_limit = 20)
}
}
