% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print.huxtable}
\alias{print.huxtable}
\alias{format.huxtable}
\title{Default print method for huxtables}
\usage{
\method{print}{huxtable}(x, ...)

\method{format}{huxtable}(x, ..., output)
}
\arguments{
\item{x}{A huxtable.}

\item{...}{Options passed to other methods.}

\item{output}{One of \code{"html"}, \code{"latex"}, \code{"md"} or \code{"screen"}}
}
\value{
\code{print} prints the huxtable and returns \code{NULL} invisibly.

\code{format} returns a string representation from \code{\link[=to_latex]{to_latex()}}, \code{\link[=to_html]{to_html()}} etc.
}
\description{
By default huxtables are printed using \code{\link[=print_screen]{print_screen()}}. In certain cases, for example
in Sweave documents, it may be
useful to change this. You can do so by setting \code{options(huxtable.print)}.
}
\examples{
\dontrun{
# to print LaTeX output:
options(huxtable.print = print_latex)
# to print huxtables like data frames:
options(huxtable.print = function(x, ...) print(as.data.frame(x)))
}
ht <- hux(a = 1:3, b = 4:6)
format(ht, output = 'screen')
format(ht, output = 'md')
}
