% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{wrap}
\alias{wrap}
\alias{wrap<-}
\alias{set_wrap}
\alias{map_wrap}
\title{Wrap cell content over multiple lines}
\usage{
wrap(ht)
wrap(ht) <- value
set_wrap(ht, row, col, value )
map_wrap(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{A logical vector or matrix.

Set to \code{NA} to reset to the default, which is \code{TRUE}.}
}
\value{
\code{wrap()} returns the \code{wrap} property.
\code{set_wrap()} returns the modified huxtable.
}
\description{
Text wrapping only really makes sense when the table \code{\link[=width]{width()}} has been set.
}
\examples{

long_text <- paste(
        rep("Some long text.", 10),
        collapse = " "
     )
ht <- huxtable(Long = long_text)
width(ht) <- 0.2
wrap(ht) <- TRUE

\dontrun{
  quick_html(ht)
}

}
