putExample=function(argument,description,example,df=NULL) {
  p=file()
  eval(parse(text=example))
  write('\n',p)
  result=paste(readLines(p),collapse='')
  close(p)

  ## escape linebreaks in HTML
  description=gsub('\n','<br/>',description)
  example=gsub('\n','<br/>',example)

  if (!is.null(argument)) {
    argument=gsub('\n','<br/>',argument)
    z=data.frame(Argument=argument,Description=description,Example=example,Result=result)
  } else  z=data.frame(Description=description,Example=example,Result=result)
  
  if (is.null(df)) df=z
  else df=rbind(df,z)
  df
}

packImages=function() {
  x=c('images/iris1.jpg','images/iris2.jpg','images/iris3.jpg')
  irisimages=NULL
  for (i in 1:length(x)) irisimages[[i]]=readBin(x[i],what='raw',n=file.info(x[i])$size)
  save(irisimages,file='data/irisimages.rda')
}

writeExample=function(filename='example-hwriter.html',irisimages=NULL) {
  ## copying data files
  try({
    write("copying 'iris*.jpg' in the current directory...",'')
    data('irisimages',envir=environment())
    x=c('iris1.jpg','iris2.jpg','iris3.jpg')
    for (i in 1:length(x)) {
      f=file(x[[i]],'wb')
      writeBin(irisimages[[i]],f)
      close(f)
    }
  })
  
  ## making webpage
  write("building the example webpage 'example-hwriter.html' in the current directory...",'')
  p=openPage(filename)
  cw=c(Argument='100px',Description='400px',Example='350px',Result='300px')
  hwname=paste('hwriter_',hwriter:::getHwriterVersion(),'.tar.gz',sep='')
  
  text=hwrite('The hwriter package',heading=1,center=TRUE)
  text=c(text,hwrite(paste(hwrite('hwriter',style='font-family:monospace'),'is an easy-to-use package able to format and output R (from the R-project) objects in HTML format. It supports advanced formatting, tables, CSS styling, images and provides a convenient mapping between R tables and HTML tables.'),br=TRUE))
  text=c(text,hwrite(paste('This is ',hwrite('hwriter',style='font-family:monospace'),' version ',hwriter:::getHwriterVersion(),', written by Gregoire Pau.',sep='')))
  text=c(text,hwrite(paste(' Download ',hwrite(hwname,style='font-family:monospace'),' ',hwrite('here',link=paste('http://www.ebi.ac.uk/~gpau/hwriter/',hwname,sep='')),' or on ',hwrite('CRAN', link='http://cran.r-project.org/'),'.',sep=''),br=T))
  text=c(text,hwrite('',br=TRUE))
  
  text=c(text,hwrite(paste('This page illustrates the behavior of optional arguments understood by',hwrite('hwrite()',style='font-family:monospace'),
               ' and shows some examples of what can be done using the',hwrite('hwriter',style='font-family:monospace'),' package.'),br=TRUE))
  text=c(text,hwrite(paste('All the examples below could be run using for',hwrite('p',style='font-family:monospace'),'either a filename, a connection or a page opened using',hwrite('openPage()',style='font-family:monospace'),'(and closed by',hwrite('closePage()',style='font-family:monospace'),' !).'),br=TRUE))

  hwrite(c(paste(text,collapse=''),''),p,dim=c(2,1),col.width='1150px',border=0)
  
  hwrite('General arguments',p,heading=2)
   df=putExample('br','Inserts a carriage return (line break, newline) at the end of the line.',
     "hwrite('The fox ', p)\nhwrite('jumps', p, br=TRUE)\nhwrite('over the...', p, br=TRUE) ")
  df=putExample('center','Centers an element.',
     "hwrite('The fox', p, center=TRUE)\nhwrite('jumps over the...', p, center=TRUE)",df)
  hwrite(df,p,row.bgcolor='#ffffaa',row.names=FALSE, col.width=cw)

  ## Text elements
  hwrite('Text elements specific arguments',p,heading=2)
  df=putExample('heading','Heading level style.',
    "hwrite('Heading 1', p, heading=1)\n
hwrite('Heading 2', p, heading=2)\n
hwrite('Heading 3', p, heading=3)")
  
  df=putExample('link','Adds an hyperlink (anchor, hypertext) reference.',
    "hwrite('The fox', p, link='http://www.fox.com')",df)
  
  df=putExample('style',"Uses an inline CSS style to render the object.
CSS styles are very versatile and allow to change the current typeface, color, margins, font, boldness, italic, padding, spacing...
See the <a href='http://www.w3schools.com/css'>W3C reference</a> or this <a href='http://www.somacon.com/p334.php'>wizard</a> to generate new styles.
",
    "hwrite('The fox ', p, style='font-weight: bold')\n hwrite('jumps over ', p, style='font-family: monospace;color: #ff2233') \n hwrite('the wall.', p, style='text-align: right; font-style: italic')",df)
      
  hwrite(df,p,row.bgcolor='#ffffaa',row.names=FALSE, col.width=cw)

  ## Vector
  hwrite('Vector specific arguments',p,heading=2)
  df=putExample('table','Controls if a vector should be displayed as a table. Default is "TRUE". If set to "FALSE", the vector is displayed as a sequence of text elements.',
    "hwrite(1:6, p, br=TRUE)\n
hwrite(1:6, p, table=FALSE)")
  
  df=putExample('dim','Sets the dimension of the table.',
    "hwrite(1:6, p, dim=c(2,3))",df)
  
  df=putExample('byrow','Controls if the table associated to the vector should be filled by columns. Default is "FALSE". If set is "TRUE", the table is filled by rows.',
    "hwrite(1:6, p, dim=c(2,3), byrow=TRUE)",df)
  
  df=putExample('names','Controls if the names of a named vector should be shown. Default is "TRUE".',
    "z=c(red=0.5, green=0.6, blue=0.7)
hwrite(z, p, br=TRUE)\n
hwrite(z, p, names=FALSE)",df)
  
  hwrite(df,p,row.bgcolor='#ffffaa',row.names=FALSE, col.width=cw)

  ## Table
  hwrite('Table specific arguments',p,heading=2)
  df=putExample('border',"Specifies the table border width.
A value of 0 implies that no borders will be drawn.
Default border styles are not really pretty. Use 'style' instead to have a finer control on borders. ",
    "hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, border='0')\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, border='3')")
  
  df=putExample('row.names\ncol.names','Specifies if the rows (resp. columns) should be displayed.',
    "hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.names=FALSE)\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.names=FALSE, col.names=FALSE)",df)
  
  df=putExample('bgcolor\nrow.bgcolor\ncol.bgcolor',"Defines cell background colors.
'bgcolor' could be either a color or a matrix containg the cell colors, which may contain NAs when some cells don't have a background color. 'bgcolor' should have the same size as the table but may contain one extra row and/or column to target heading cells.
'row.bgcolor' (resp. 'col.bgcolor') may contain a list of named vectors of colors pointing the corresponding rows (resp. columns) names. If sizes don't match, values are recycled using R style. Unnamed vector of colors points the heading rows (resp. columns).",
    "hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, bgcolor=matrix(c('#afa', NA, NA, '#afa'),nr=2,nc=2))\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, col.bgcolor=list(Sepal.Width=c('#6ff','#aff','#eff')))\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.bgcolor='#ffffaa')",df)
  
  df=putExample('style\nrow.style\ncol.style',"Defines cell CSS style.
Uses the same pointing mechanism as 'bgcolor', 'row.bgcolor' and 'col.bgcolor'.
CSS styles are very versatile and allow to change border style, typeface, font properties, align, boldness, font color, italic...
See the <a href='http://www.w3schools.com/css'>W3C reference</a>, this <a href='http://www.somacon.com/p141.php'>wizard</a> or this <a href='http://www.somacon.com/p334.php'>wizard</a> to generate new styles. Please note that the 'bgcolor' argument and the background-color CSS property may interact in an unspecific maneer.",
    "hwrite(iris[1:2,1:2], p, br=TRUE, center=TRUE, style='font-family: monospace ; border-spacing: 5px; border-collapse: collapse;')\n\n
hwrite(iris[1:2,1:2], p, br=TRUE, center=TRUE, col.style=list(Sepal.Length = 'text-align:center; color:#a00'))\n\n
hwrite(iris[1:2,1:2], p, br=TRUE, center=TRUE, row.style=list('font-weight:bold'), style=matrix(c(NA, 'color:#f00', 'color:#00f', NA),nr=2,nc=2))\n\n
",df)
  
  df=putExample('link\nrow.link\ncol.link',"Defines cell hyperlinks.
Uses the same 'bgcolor', 'row.bgcolor and 'col.bgcolor' mechanism but uses URLs instead of colors.",
    "hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, link=matrix(c('http://www.ab.com', NA, NA, 'http://www.bc.com'),nr=2,nc=2))\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, col.link=list(Sepal.Width='http://www.cd.com'))\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.link='http://www.uk.com')",df)
  
  df=putExample('cellspacing\ncellpadding',"Defines padding and spacing between cells.",
    "hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.bgcolor='#ffaaaa')\n\n\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.bgcolor='#ffaaaa', cellspacing=10)\n\n\n\n\n
hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, row.bgcolor='#ffaaaa', cellpadding=10)",df)

  df=putExample('width\ncol.width',"Defines global table width and column widths in HTML units (pixels or %).\n'width' specifies the table global width.\n'col.width' contains either a vector of widths (of size equals to the number of columns) which may contain NAs or a named vector of widths which point to some column names.",
    "hwrite(iris[1:2,1:2], p, center=TRUE, br=TRUE, col.width=c(Sepal.Length='150px'))",df)
      hwrite(df,p,row.bgcolor='#ffffaa',row.names=FALSE, col.width=cw)

  ## Examples
  hwrite('Examples',p,heading=1)
  df=putExample(NULL,"Concatenating HTLM elements. 
Using 'hwrite' without output connection produces HTML code parts. Resulting HTML elements can be concatenated using 'paste'.",
     "hwrite(paste('The fox jumps ',hwrite('over', link='http://over.com'),' the ', hwrite('red', style='color:#c35'),' wall.', collapse=''),p, br=TRUE)\n
hwrite(paste('The function', hwrite( 'hwrite()', style='font-family:monospace'), 'is cool !'), p)
")
  
  df=putExample(NULL,"Using matrices to build HTML layout tables.
HTML code parts can be easily bound in a HTML table layout.",
    "tab=hwrite(iris[1:3,1:3], center=TRUE, style='border-collapse: collapse;', row.bgcolor='#fca')
caption=hwrite('Fig.1 - Iris data', style='font-weight: bold')
hwrite(c(tab, cap=caption), p, center=TRUE, border='0', dim=c(2,1), row.style=list(cap='text-align:center'), row.names=FALSE)",df)

  df=putExample(NULL,'Pointing different columns and rows.',"
spcolor=iris$Species[1:8]
levels(spcolor)=c('#faa','#afa','#aaf')
hwrite(iris[1:8,], p, center=TRUE, row.bgcolor=list('#afa', '3'='#ffa', '5'=c('#faf','#daf','#baf','#9af','#7af','#5af')), col.style=list(Species='font-style:italic'), row.style=list('font-weight:bold'), col.link=list(Sepal.Width=iris$Sepal.Width[1:8]))",df)
  
  df=putExample(NULL,"Mixing images, hyperlinking and HTML tables.
Using hwriteImage and concatenating HTML elements.",
    "i1=hwrite(hwriteImage('iris1.jpg'), link='http://en.wikipedia.org/wiki/Iris_virginica')
i2=hwrite(hwriteImage('iris2.jpg'), link='http://en.wikipedia.org/wiki/Iris_versicolor')
i3=hwrite(hwriteImage('iris3.jpg'), link='http://en.wikipedia.org/wiki/Iris_virginica')
m=matrix(c(i1, 'Setosa',i2, 'Versicolor', i3, 'Virginica'), nr=2, nc=3)
rownames(m)=c('Image', 'Species')
hwrite(m, p, br=TRUE, center=TRUE, row.bgcolor=list(Species=c('#fac', '#f8a', '#f68')), style='text-align:center; border-collapse:collapse', col.bgcolor='#ffa')
",df)

  df=putExample(NULL,'Fancy patchwork. Advanced text formatting.',"
cases=matrix('', nr=6, nc=5)
hotcolors=rgb(colorRamp(c('#ff0000', '#ffff00', '#ffffff'), space='rgb')(runif(6*5)),max=255)
bgcolor=matrix(hotcolors, nr=6, nc=5)
rownames(cases)=1:6
patchwork=hwrite(cases, bgcolor=bgcolor, style='font-family:monospace', col.width=rep('12px',6))
text='La volupt&eacute; de la chair est une chose de la vie des sens au meme titre que le regard pur, que la pure saveur d\\'un beau fruit sur notre langue...'
text=paste(hwrite(text, br=TRUE), hwrite('Rainer Maria Rilke', style='font-style:italic'))
hwrite(c(patchwork,text), p, br=TRUE, center=TRUE, col.width=c(NA,'200px'), style='text-align:justify', border=0, cellspacing=10)
",df)

  if (FALSE) try({df=putExample(NULL,'Capture and insert a PNG image from the current graphics device.',"
x=10*(1:nrow(volcano))
y=10*(1:ncol(volcano))
x11() ; par(ask=FALSE)
image(x, y, volcano, col=terrain.colors(100), axes=FALSE, main='Maunga Whau Volcano', xlab='', ylab='')
contour(x, y, volcano, levels=seq(90, 200, by=5), add=TRUE, col='peru')
axis(1, at=seq(100, 800, by=100))
axis(2, at=seq(100, 600, by=100))
box()
hwriteImage('volcano.png', p, capture=TRUE, br=TRUE)
dev.off()
",df)})
  
  hwrite(df,p,row.bgcolor='#ffffaa',row.names=FALSE, col.width=c('350px','450px','350px'))
  
  closePage(p)

  ## open browser
  write("opening a web browser on 'example-hwriter.html' ...",'')
  write("OK. A web page showing all the examples should have been opened.",'')
  try(browseURL('example-hwriter.html'))
}


