% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_cum_sum.R
\name{cum_sum}
\alias{cum_sum}
\title{Cumulative sum}
\usage{
cum_sum(x, col_name, out_name = NULL)
}
\arguments{
\item{x}{data frame with class \code{Date} or \code{POSIXct} in the first column and
numeric on the others.}

\item{col_name}{string with column(s) name(s) where to apply the function.}

\item{out_name}{optional. String with new column(s) name(s). If you set it as \code{NULL},
the function will overwrite the original data frame.}
}
\value{
The same data frame but with the new series.
}
\description{
The function supports \code{NA_real_} values. It could be very
useful when dealing with incomplete precipitation series.
}
\examples{

# set path to file
path <- system.file('extdata', 'ianigla_cuevas.csv',
         package = 'hydrotoolbox')

# read the file and add the new column with cumulative precipitation
cuevas <-
  read_ianigla(path = path) \%>\%
  cum_sum(col_name = 'Precip_Total', out_name = 'p_cum')

# plot it
plot(x = cuevas[ , 'date'], y = cuevas[ , 'p_cum'],
     col = 'red', type = 'l',
     xlab = 'Date', ylab = 'Pcum(mm)')



}
