\name{spc-identify}
\alias{spc.identify}
\title{Identifying Spectra and Spectral Data Points...}
\usage{spc.identify(x, y=NULL, wavelengths=NULL, ispc=NULL, tol.wl=diff(range(x))/200,
    tol.spc=diff(range(y))/50, point.fn=spc.point.max,
    formatter=spc.label.default, ..., cex=0.7, adj=c(0, 0.5), srt=90,
    warn=TRUE)

spc.point.max(wl, spc, wlclick)


spc.point.default(wl, spc, wlclick)


spc.point.min(wl, spc, wlclick)


spc.point.sqr(wl, spc, wlclick, delta=1)


spc.label.default(ispc, wl, spc, digits=3)


spc.label.wlonly(ispc, wl, spc, digits=3)

}
\description{Identifying Spectra and Spectral Data Points
This function allows to identify the spectrum and the wavelength of a point
in a plot produced by \code{\link{plotspc}}.}
\details{\code{spc.identify}: This function first finds the spectrum with a point closest to the clicked
position (see \code{\link[graphics]{locator}}). The distance to the clicked
point is evaluated relative to the size of the tolerance window.

In a second step, \code{max.fn} searches for the actual point to label
within the specified wavelength window of that spectrum. This allows to
label maxima (or minima) without demanding too precise clicks. Currently,
the following functions to determine the precise point: \tabular{ll}{
spc.point.default \tab uses the clicked wavelength together with its
spectral intensity\cr spc.point.max \tab the point with the highest
intensity in the wavelength window \cr spc.point.min \tab the point with
the lowest intensity in the wavelength window \cr spc.point.sqr \tab
maximum of a parabola fit throug the point with highest intensity and the
two surrounding points \cr } \code{point.fn} is called with the arguments
\code{wl} containing the considered wavelength window, \code{spc} the
respective intensities of the closest spectrum, and \code{wlclick} the
wavelength that was clicked. They return a vector of two elements
(wavelength and intensity).

As a last step, a label for the point produced by \code{formatter} and
plotted using \code{\link[graphics]{text}}. Currently, the following
\code{formatter}s are available: \tabular{ll}{ spc.label.default \tab
spectrum number, wavelength \cr spc.label.wlonly \tab wavelength\cr }
\code{formatter} functions receive the number of the spectrum \code{ispc},
the wavelength \code{wl}, and the spectral intensity \code{spc} and produce
a character variable suitable for labelling. The predefined formatters
surround the label text by spaces in order to easily have an appropriate
offset from the point of the spectrum.

The warning issued if no spectral point is inside the tolerance window may
be switched of by \code{warn = FALSE}. In that case, the click will produce
a row of \code{NA}s in the resulting data.frame.

\code{spc.identify} uses option \code{debuglevel} to determine whether debugging output should be
produced. \code{debuglevel == 2} will plot the tolerance window for every clicked point,
\code{debuglevel == 1} will plot the tolerance window only if no data point was inside.  See
\code{\link[hyperSpec:options]{hyperSpec options}} for details about retrieving and setting
options.

You may want to adjust the plot's \code{ylim} to ensure that the labels are
not clipped. As a dirty shortcut, \code{xpd = NA} may help.

}
\alias{spc.identify}
\alias{spc.label.default}
\alias{spc.label.wlonly}
\alias{spc.point.default}
\alias{spc.point.max}
\alias{spc.point.min}
\alias{spc.point.sqr}
\value{\code{spc.identify}: a \code{data.frame} with columns \item{ispc}{spectra indices of the
identified points, i.e. the rows of the \code{hyperSpec} object that was
plotted.

If \code{ispc} is given, \code{ispc [i]} is returned rather than \code{i}.
} \item{wavelengths}{the wavelengths of the identified points}
\item{spc}{the intensities of the identified points}

}
\author{C. Beleites}
\seealso{\code{\link[graphics]{locator}}, \code{\link{plotspc}},
\code{\link[hyperSpec:options]{hyperSpec options}}

\code{\link{map.identify}} \code{\link{map.sel.poly}}}
\keyword{iplot}
\arguments{\item{x}{either the abscissa coordinates or the list returned by
\code{\link{plotspc}}}
\item{y}{the ordinate values. Giving \code{y} will override any values from
\code{x$y}.}
\item{wavelengths}{the wavelengths for the data points. Giving
\code{wavelengths} will override any values from \code{x$wavelengths}.}
\item{tol.wl,tol.spc}{tolerance in wavelength and spectral intensity to
search around the clicked point. See details.}
\item{point.fn}{\code{function (wl, spc, wlclick)} to determine the actual
point to label, see details.}
\item{formatter}{\code{function (i, wl, spc)} that produces the labels. If
\code{NULL}, no labels are displayed.}
\item{\dots}{passed to \code{\link[graphics]{text}} in order to produce the
labels}
\item{cex,adj,srt}{see \code{\link[graphics]{par}}}
\item{warn}{Should the user be warned if no point is in the considered
window? In addition, see the discussion of option \code{debuglevel} in
the details.

If \code{FALSE}, the resulting data.frame will have a row of \code{NA}s
instead.}
\item{delta}{\code{spc.point.sqr} fits the parabola in the window wlclick
\eqn{\pm}{+-} delta points.}
\item{wl}{the wavelength to label}
\item{spc}{the intensity to label}
\item{wlclick}{the clicked wavelength}
\item{ispc}{if a selection of spectra was plotted, their indices can be
given in \code{ispc}. In this case \code{ispc [i]} is returned rather
than \code{i}.}
\item{digits}{how many digits of the wavelength should be displayed?}
}
\examples{
\donttest{
ispc <- sample (nrow (laser), 10)
ispc

identified <- spc.identify (plotspc (laser[ispc]))
## convert to the "real" spectra indices
ispc [identified$ispc]
identified$wl
identified$spc

## allow the labels to be plotted into the plot margin
spc.identify (plotspc (laser[ispc]), ispc = ispc, xpd = NA) 

spc.identify (plotspc (paracetamol, xoffset = 1100,
wl.range = c (600 ~ 1700, 2900 ~ 3150)),
formatter = spc.label.wlonly)

## looking for minima
spc.identify (plot (-paracetamol, wl.reverse = TRUE),
point.fn = spc.point.min, adj = c (1, 0.5))

}
}
\alias{spc.point.max}
\alias{spc.point.default}
\alias{spc.point.min}
\alias{spc.point.sqr}
\alias{spc.label.default}
\alias{spc.label.wlonly}

