/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class LFSR113
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064359965952E-10;
    private int z0;
    private int z1;
    private int z2;
    private int z3;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream = new int[]{987654321, 987654321, 987654321, 987654321};

    public LFSR113() {
        this.name = null;
        this.stream = new int[4];
        this.substream = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.resetStartStream();
        int z = curr_stream[0] & 0xFFFFFFFE;
        int b = z << 6 ^ z;
        LFSR113.curr_stream[0] = z = z ^ z << 2 ^ z << 3 ^ z << 10 ^ z << 13 ^ z << 16 ^ z << 19 ^ z << 22 ^ z << 25 ^ z << 27 ^ z << 28 ^ b >>> 3 ^ b >>> 4 ^ b >>> 6 ^ b >>> 9 ^ b >>> 12 ^ b >>> 15 ^ b >>> 18 ^ b >>> 21;
        z = curr_stream[1] & 0xFFFFFFF8;
        b = z << 2 ^ z;
        LFSR113.curr_stream[1] = z = b >>> 13 ^ z << 16;
        z = curr_stream[2] & 0xFFFFFFF0;
        b = z << 13 ^ z;
        LFSR113.curr_stream[2] = z = z << 2 ^ z << 4 ^ z << 10 ^ z << 12 ^ z << 13 ^ z << 17 ^ z << 25 ^ b >>> 3 ^ b >>> 11 ^ b >>> 15 ^ b >>> 16 ^ b >>> 24;
        z = curr_stream[3] & 0xFFFFFF80;
        b = z << 3 ^ z;
        LFSR113.curr_stream[3] = z = z << 9 ^ z << 10 ^ z << 11 ^ z << 14 ^ z << 16 ^ z << 18 ^ z << 23 ^ z << 24 ^ b >>> 1 ^ b >>> 2 ^ b >>> 7 ^ b >>> 9 ^ b >>> 11 ^ b >>> 14 ^ b >>> 15 ^ b >>> 16 ^ b >>> 23 ^ b >>> 24;
    }

    public LFSR113(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(int[] seed) {
        LFSR113.checkSeed(seed);
        for (int i = 0; i < 4; ++i) {
            LFSR113.curr_stream[i] = seed[i];
        }
    }

    private static void checkSeed(int[] seed) {
        if (seed.length < 4) {
            throw new IllegalArgumentException("Seed must contain 4 values");
        }
        if (seed[0] >= 0 && seed[0] < 2 || seed[1] >= 0 && seed[1] < 8 || seed[2] >= 0 && seed[2] < 16 || seed[3] >= 0 && seed[3] < 128) {
            throw new IllegalArgumentException("The seed elements must be either negative or greater than 1, 7, 15 and 127 respectively");
        }
    }

    public void setSeed(int[] seed) {
        LFSR113.checkSeed(seed);
        for (int i = 0; i < 4; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        return new int[]{this.z0, this.z1, this.z2, this.z3};
    }

    public LFSR113 clone() {
        LFSR113 retour = null;
        retour = (LFSR113)super.clone();
        retour.stream = new int[4];
        retour.substream = new int[4];
        for (int i = 0; i < 4; ++i) {
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    public void resetStartStream() {
        for (int i = 0; i < 4; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.z0 = this.substream[0];
        this.z1 = this.substream[1];
        this.z2 = this.substream[2];
        this.z3 = this.substream[3];
    }

    public void resetNextSubstream() {
        int z = this.substream[0] & 0xFFFFFFFE;
        int b = z << 6 ^ z;
        z = z ^ z << 3 ^ z << 4 ^ z << 6 ^ z << 7 ^ z << 8 ^ z << 10 ^ z << 11 ^ z << 13 ^ z << 14 ^ z << 16 ^ z << 17 ^ z << 18 ^ z << 22 ^ z << 24 ^ z << 25 ^ z << 26 ^ z << 28 ^ z << 30;
        this.substream[0] = z ^= b >>> 1 ^ b >>> 3 ^ b >>> 5 ^ b >>> 6 ^ b >>> 7 ^ b >>> 9 ^ b >>> 13 ^ b >>> 14 ^ b >>> 15 ^ b >>> 17 ^ b >>> 18 ^ b >>> 20 ^ b >>> 21 ^ b >>> 23 ^ b >>> 24 ^ b >>> 25 ^ b >>> 26 ^ b >>> 27 ^ b >>> 30;
        z = this.substream[1] & 0xFFFFFFF8;
        b = z ^ z << 1;
        b ^= b << 2;
        b ^= b << 4;
        b ^= b << 8;
        b <<= 8;
        b ^= z << 22 ^ z << 25 ^ z << 27;
        if ((z & Integer.MIN_VALUE) != 0) {
            b ^= 0xABFFF000;
        }
        if ((z & 0x40000000) != 0) {
            b ^= 0x55FFF800;
        }
        this.substream[1] = z = b ^ z >>> 7 ^ z >>> 20 ^ z >>> 21;
        z = this.substream[2] & 0xFFFFFFF0;
        b = z << 13 ^ z;
        this.substream[2] = z = b >>> 3 ^ b >>> 17 ^ z << 10 ^ z << 11 ^ z << 25;
        z = this.substream[3] & 0xFFFFFF80;
        b = z << 3 ^ z;
        this.substream[3] = z = z << 14 ^ z << 16 ^ z << 20 ^ b >>> 5 ^ b >>> 9 ^ b >>> 11;
        this.resetStartSubstream();
    }

    public String toString() {
        if (this.name == null) {
            return "The state of the LFSR113 is: { " + this.z0 + ", " + this.z1 + ", " + this.z2 + ", " + this.z3 + " }";
        }
        return "The state of " + this.name + " is: { " + this.z0 + ", " + this.z1 + ", " + this.z2 + ", " + this.z3 + " }";
    }

    private long nextNumber() {
        int b = (this.z0 << 6 ^ this.z0) >>> 13;
        this.z0 = (this.z0 & 0xFFFFFFFE) << 18 ^ b;
        b = (this.z1 << 2 ^ this.z1) >>> 27;
        this.z1 = (this.z1 & 0xFFFFFFF8) << 2 ^ b;
        b = (this.z2 << 13 ^ this.z2) >>> 21;
        this.z2 = (this.z2 & 0xFFFFFFF0) << 7 ^ b;
        b = (this.z3 << 3 ^ this.z3) >>> 12;
        this.z3 = (this.z3 & 0xFFFFFF80) << 13 ^ b;
        long r = this.z0 ^ this.z1 ^ this.z2 ^ this.z3;
        if (r <= 0L) {
            r += 0x100000000L;
        }
        return r;
    }

    protected double nextValue() {
        return (double)this.nextNumber() * 2.3283064359965952E-10;
    }

    public int nextInt(int i, int j) {
        long res;
        if (i > j) {
            throw new IllegalArgumentException(i + " is larger than " + j + ".");
        }
        long d = (long)(j - i) + 1L;
        long q = 0x100000000L / d;
        long r = 0x100000000L % d;
        while ((res = this.nextNumber()) >= 0x100000000L - r) {
        }
        return (int)(res / q) + i;
    }
}

