% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coverage.R
\name{Coverage}
\alias{Coverage}
\title{Compute sample coverage}
\usage{
Coverage(x, datatype, m)
}
\arguments{
\item{x}{a vector/matrix/list of species abundances/incidence frequencies or a matrix of incidence table.\cr 
If \code{datatype = "incidence_freq"}, then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}),
sampling-unit-based incidence frequencies data (\code{datatype = "incidence_freq"}) or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{m}{an integer vector of sample sizes (number of individuals or sampling units) for which diversity estimates will be computed.}
}
\value{
a data.frame with sample size and sample coverage.
}
\description{
\code{Coverage}: Compute sample coverage
}
\examples{
data(bird)
Coverage(bird$abun, datatype="abundance", m=c(10,50,100,150,200))
}

