% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.R
\name{fortify.iNextPD}
\alias{fortify.iNextPD}
\title{Fortify method for classes from the iNextPD package.}
\usage{
\method{fortify}{iNextPD}(model, data = model$iNextPDEst, type = 1,
  se = TRUE, ...)
}
\arguments{
\item{model}{\code{iNextPD} to convert into a dataframe.}

\item{data}{not used by this method}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1}); 
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{se}{a logical variable to calculate the bootstrap standard error and \code{conf} confidence interval.}

\item{...}{not used by this method}
}
\description{
Fortify method for classes from the iNextPD package.
}
\examples{
# single-assemblage abundance data
data(bird)
bird.lab <- rownames(bird$abun)
bird.phy <- ade4::newick2phylog(bird$tre)
out1 <- iNextPD(bird$abun$North.site, bird.lab, bird.phy, 
        q=0, datatype="abundance", endpoint=400)
ggplot2::fortify(out1, type=1)
}

