% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{fit_transform_cv}
\alias{fit_transform_cv}
\title{Train a grid using cross-validation with features and impute all missing
values in these features}
\usage{
fit_transform_cv(grid, X, ...)
}
\arguments{
\item{grid}{The grid to use for imputation}

\item{X}{The features of the data.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v1.2.0/IAIBase/reference/#IAI.fit_transform_cv!}{\code{IAI.fit_transform_cv!}}
}
\examples{
\donttest{
X <- iris
X[1, 1] <- NA
grid <- iai::grid_search(
    iai::imputation_learner(),
    method = c("opt_knn", "opt_tree"),
)
iai::fit_transform_cv(grid, X)
}
}
