% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condense.R
\name{icd_condense}
\alias{icd_condense}
\alias{icd_condense.character}
\alias{icd9_condense_decimal}
\alias{icd9_condense_short}
\title{Condense ICD-9 code by replacing complete families with parent codes}
\usage{
icd_condense(x, short_code = icd_guess_short(x), defined = NULL,
  warn = TRUE, ...)

\method{icd_condense}{character}(x, short_code = icd_guess_short(x),
  defined = NULL, ...)

icd9_condense_decimal(x, defined = NULL, warn = TRUE,
  keep_factor_levels = FALSE)

icd9_condense_short(x, defined = NULL, warn = TRUE,
  keep_factor_levels = FALSE)
}
\arguments{
\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{warn}{single logical value, if \code{TRUE}, give warnings when
there is discrepancy between \code{onlyReal} being \code{TRUE} yet data
containing undefined codes.}

\item{...}{arguments passed on to other functions}

\item{keep_factor_levels}{single logical value, default \code{FALSE}. If
\code{TRUE}, will reuse the factor levels from the input data for the
output data. This only applies if a factor is given for the input codes.}

\item{icd9}{is a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\description{
This can be thought of as the inverse operation to
  \code{icd_children}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Condense a set of ICD codes, guessing ICD version
from input data
}}

\seealso{
Other ICD-9 ranges: \code{\link{icd_children}},
  \code{\link{icd_expand_minor}},
  \code{\link{icd_expand_range}}
}
\keyword{internal}
\keyword{manip}
